## tl;dr – I don’t code but I want support for nodes from `mymod`!

[Feel free to contact me somewhere](https://0x7be.de/external).

## Path structure and settings options for built-in support files

The directories in this directory referencing a game ID. The Lua files in that directories referencing a mod ID.

For example, when adding support for `my_cool_mod` which is loaded in `my_game`, the path needs to be the following:

```
./my_game/my_cool_mod.optional_specification.lua
```

The file name is the processed into two parts and a `true`-by-default option is validated.

1. `my_cool_mod`
2. `optional_specification`

This checks the following parameter, where `game` is replaced with the current game’s ID:

```ini
ladders_3d_game_optional_specification = true
```

If no optional specification is given, the mod name is used instead:

```ini
ladders_3d_game_my_cool_mod = true
```

You can have multiple files using the same settings option:

```
my_cool_mod.my_option.lua
another_mod.my_option.lua
third_mod.my_option.lua
```

Those all use the same settings option:

```ini
ladders_3d_game_my_option = true
```

… granted the mods are loaded.

## API access

Code in this files has access to the following *Ladders 3D* API features during the mod’s loading stage.

* `ladders_3d.register` – The function that is used to register 3D ladders. See below for details.
* `ladders_3d.mass_register` – Mass registering function. See below for details.

Also the following convenience functions

* `ladders_3d.game` – A table of various game-related information as per Luanti API. Most relevant might be `ladders_3d.game.id` being the game ID.
* `ladders_3d.log` – Logging function with automatic prefixing, works similar to `core.log`
* `ladders_3d.option` – Preconfigured options interface to load settings from global or world-specific configuration
* `ladders_3d.translator` – A preconfigured translator within the `ladders_3d` translation namespace.
* `ladders_3d.worldconfig` – The world-specific configuration or `nil` if there is no world-specific configuration.

After *Ladders 3D* was loaded, the API is reduced to `ladders_3d.register` and `ladders_3d.mass_register` only. Mods (opt-)depending on `ladders_3d` only have access to this two functionw. The additional functions are only relevant within the loading stage of `ladders_3d`. Mods need to take care of anything else on their own while in their loading stage.

## Registering ladders as 3D nodeboxes

With the `ladders_3d.register` API function a 3D ladder can be registered. The function takes a short ID and a definition table as parameters.

```lua
ladders_3d.register('my_cool_ladder', {
    description = 'My Cool Ladder',
    recipe = {},        -- Shaped recipe table as per Luanti API
    yield = 7,          -- Amount of ladders on crafting
    uncraft = '',       -- The result on “uncrafting”
    tiles = {},         -- Tiles table as per Luanti API
    sounds = {},        -- SimpleSoundSpec as per Luanti API
    light = 0,          -- Amount of light (`light_source`)
    groups = {},        -- Additional groups to set
    nodebox = {},       -- Fixed Nodebox table as per Luanti API
    selectionbox = {},  -- Fixed selection box table as per Luanti API
    walkable = false,   -- If the node is walkable or not.
    image = '',         -- Texture/Image to be shown in hand or inventory
    parameters = {}     -- Add arbitrary parameters to the node definition
})
```

When the node is created the short ID is automatically prefixed, the example code would result in `ladders_3d:my_cool_ladder` as node name.

When `nodebox` is omitted, the default nodebox is used. The default nodebox resembles the “Minetest Game” `default` ladder shape, but in 3D. When `selectionbox` is omitted, the default selection box is used. This resembles the “Minetest Game” `default` ladder selection box shape, but in 3D. When the default nodebox and selection box are used, the configuration can override the default selection box to be shaped like the default nodebox.

The `groups` table can be used to add arbitrary groups to the registered ladder node. By default no groups are set to make the mod as flexible as possible. For most games, you might want to add `dig_immediate = 2` as group here, so players can dig the ladders.

`walkable` is a bit confusing. If it is `false`, players can walk through the registered node. If it is `true` players cannot walk through the registered node. A configuration option can override the default. If you want the ladder to be explicitly walkable (or not), you need to set this option.

With `image` it is possible to define an image/texture that is shown in the inventory and when wielding the ladder instead of using the nodebox for this. If omitted, the created nodebox is used.

By filling the `parameters` table with key/value pairs, you can add arbitrary parameters to the node definition. This is done right before the node registration. This can be used for games that need certain parameters to be set that are not part of a common node registration.

The example shows the default values of the parameters (the `description` defaults to the registered ladder’s node ID if it is omitted). Technically all parameters in the table are optional. But this would result in a pretty generic and randomly colored ladder.

## Adding additional ladders

As described: All files in the registry are automatically loaded and checked if a mod with the file name is present. If this is the case, the file is loaded. An example file could look like this:

```lua
-- Get my cool node’s definition
local node_def = core.registered_nodes['mymod:my_cool_node']

-- Register `ladders_3d:my_cool_ladder`
ladders_3d.register('my_cool_ladder', {
    description = 'Ladder made from my cool node',
    recipe = {
        { 'mymod:my_cool_node', '',                   'mymod:my_cool_node' }
        { 'mymod:my_cool_node', 'mymod:my_cool_node', 'mymod:my_cool_node' }
        { 'mymod:my_cool_node', '',                   'mymod:my_cool_node' }
    },
    uncraft = 'mymod:my_cool_node 1',
    sounds = node_def.sounds,
    tiles = node_def.tiles,
    groups = { dig_immediate = 2, mymod_ladder = 1 }
})
```

This example creates a 3D ladder with default nodebox shape and default selection box using `mymod:my_cool_node` in an `H` shape as recipe. The default yield of `7` is used and when uncrafting, 1 of the `mymod:my_cool_node` nodes is returned. The ladder uses the sounds and tiles of `mymod:my_cool_node` and adds the groups `dig_immediate = 2` and `mymod_ladder = 1` to the registered node.

### Mass registration

The API provides an option to mass-register ladders with limited functionality.

The following table needs to be provided in order to register multiple ladders in one go. All entries except `ladders` are optional and will fall back to default values.

```lua
ladders_3d.mass_register({
    groups = {},  -- Groups for the registered ladders
    nodebox = {}, -- Nodebox for the registered ladders
    sounds = {},  -- Fallback SimpleSoundSpec
    shading = 32, -- Strength of the shading mask
    ladders = {   -- Table of ladder definitions
        my_cool_id = { 'Name',       'mymod:mynode',      'mymod_texture.png' },
        the_second = { 'Cool Name',  'crafting:material', 'base_texture.png' },
        other_id =   { 'Other Name', 'other:material',    'other_texture.png' },
        -- ... and so on
    }
})
```

The `ladders` table entry ID will be expanded to `ladders_3d:THE_ID` where `THE_ID` is the table entry ID (e.g. `ladders_3d:my_cool_id`).

The function assumes the following files to be existing and looking like it’s needed for the game `GAME` (which will always be the currently active game’s ID).

* `ladders_3d_GAME_inventory_mask.png`
* `ladders_3d_GAME_shading_mask.png`

The recipe automatically is a `H` shape with `mymod:mynode`, crafting yield is 7, and return is 1 of `mymod:mynode`.

Additional options are not settable. If you need to register ladders with very specific values, you need to come up with your own logic for that and use the regular function.

## Use the API in an own mod

You can use the registration function as described in your own mods. Just depend or optionally depend on `ladders_3d` and then invoke `ladders_3d.register` as you need to. Please note that you need to manually check validity of what you’re doing.
