local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register


-- Normal, upright nodebox
local nodebox = {
    {-0.375, -0.5, 0.375, -0.25, 0.5, 0.5},       -- strut_l
    {0.25, -0.5, 0.375, 0.375, 0.5, 0.5},         -- strut_r
    {-0.4375, 0.25, 0.375, 0.4375, 0.375, 0.5},   -- rung_top
    {-0.4375, -0.25, 0.375, 0.4375, -0.125, 0.5}, -- rung_bottom
    {-0.25, 0.125, 0.375, -0.1875, 0.25, 0.5},    -- holder_tl
    {0.1875, 0.125, 0.375, 0.25, 0.25, 0.5},      -- holder_tr
    {-0.25, -0.375, 0.375, -0.1875, -0.25, 0.5},  -- holder_bl
    {0.1875, -0.375, 0.375, 0.25, -0.25, 0.5},    -- holder_br
}


-- Groups from the default ladder (minus tool specific groups and
-- property groups)
local groups = {
    creative_breakable = 1,
    deco_block = 1,
    dig_by_piston = 1,
    handy = 1,
    handy_dig = 6,
    pathfinder_partial = 1,
}


-- Texture creation
local m = 'ladders_3d_mineclone2_screws_mask.png'
local t=function (b, o) return b..'^('..m..'^[opacity:'..(o or 96)..')' end


mass_register({
    groups = groups,
    nodebox = nodebox,
    ladders = {
        mcl_bamboo_blank =               { S('Bamboo Ladder'),               'mcl_bamboo:bamboo_blank',         t('mcl_bamboo_bamboo_plank.png', 64)     },
        mcl_cherry_blossom_cherrywood =  { S('Cherry Blossom Wood Ladder'),  'mcl_cherry_blossom:cherrywood',   t('mcl_cherry_blossom_planks.png')       },
        mcl_core_acaciawood =            { S('Acacia Wood Ladder'),          'mcl_core:acaciawood',             t('default_acacia_wood.png')             },
        mcl_core_birchwood =             { S('Birch Wood Ladder'),           'mcl_core:birchwood',              t('mcl_core_planks_birch.png')           },
        mcl_core_dark =                  { S('Dark Wood Ladder'),            'mcl_core:darkwood',               t('mcl_core_planks_big_oak.png')         },
        mcl_core_junglewood =            { S('Jungle Wood Ladder'),          'mcl_core:junglewood',             t('default_junglewood.png')              },
        mcl_core_mangrove_wood =         { S('Magrove Wood Ladder'),         'mcl_core:mangrove_wood',          t('mcl_mangrove_planks.png')             },
        mcl_core_sprucewood =            { S('Spruce Wood Ladder'),          'mcl_core:sprucewood',             t('mcl_core_planks_spruce.png')          },
        mcl_crimson_hyphae_wood =        { S('Crimson Wood Ladder'),         'mcl_crimson:crimson_hyphae_wood', t('mcl_crimson_crimson_hyphae_wood.png') },
        mcl_crimson_warped_hyphae_wood = { S('Warped Wood Ladder'),          'mcl_crimson:warped_hyphae_wood',  t('mcl_crimson_warped_hyphae_wood.png')  },
    }
})
