local S = ladders_3d.translator
local register = ladders_3d.register


local nodebox = {
    { -0.4375, -0.5, 0.375, -0.25, 0.5, 0.5 },      -- strut_l
    { 0.25, -0.5, 0.375, 0.4375, 0.5, 0.5 },        -- strut_r
    { -0.25, 0.1875, 0.4375, 0.25, 0.3125, 0.5 },   -- rung_t
    { -0.25, -0.3125, 0.4375, 0.25, -0.1875, 0.5 }, -- rung_b
}


local groups = {
    creative_decoblock = 1,
    level = -3,
    oddly_breakable_by_hand = 3,
}


local ladders = {
    bronze       = S('Bronze Ladder'),
    carbon_steel = S('Carbon Steel Ladder'),
    copper       = S('Copper Ladder'),
    gold         = S('Golden Ladder'),
    steel        = S('Steel Ladder'),
    tin          = S('Tin Ladder'),
    wrought_iron = S('Wrought Iron Ladder')
}


for id,name in pairs(ladders) do
    -- Gold comes from rp_gold while other metals come from rp_default. For
    -- having every metal in one loop, the modname is adjusted.
    local modname = id ~= 'gold' and 'rp_default' or 'rp_gold'

    -- Get needed IDs and names
    local base_node = modname..':block_'..id
    local base_def = core.registered_nodes[base_node]
    local material = modname..':ingot_'..id
    local base_texture = base_def.tiles[1]

    local connectors = ('((((+b)^[+t)^[multiply:+m)^[mask:+s)'):gsub('%+%w', {
        ['+t'] = 'transformR90',
        ['+m'] = '#888888',
        ['+b'] = base_texture,
        ['+s'] = 'ladders_3d_repixture_connectors_mask.png'
    })

    local texture = ('((+b)^(+s^[opacity:64))'):gsub('%+%w', {
        ['+b'] = base_texture,
        ['+s'] = 'ladders_3d_repixture_shading_mask.png',
    })

    local texture_connectors = ('(+t^+c)'):gsub('%+%w', {
        ['+t'] = texture,
        ['+c'] = connectors
    })

    local inventory_image = ('((+tc^[mask:+im)^+io)'):gsub('%+%w+', {
        ['+tc'] = texture_connectors,
        ['+im'] = 'ladders_3d_repixture_inventory_mask.png',
        ['+io'] = 'ladders_3d_repixture_inventory_outline.png'
    })

    local registered_ladder = register('ladder_'..id, {
        description = name,
        nodebox = { type = 'fixed', fixed = nodebox },
        sounds = base_def.sounds,
        groups = groups,
        image = inventory_image,
        tiles = {
            texture,  -- top
            texture,  -- bottom
            texture,  -- right
            texture,  -- left
            texture,  -- “front” (back)
            texture_connectors, -- “back” (front)
        }
    })

    -- Using Repixture craft registering API
    --
    -- The `rp_crafting` mod that provides the `crafting` API is a mandatory
    -- dependency of `rp_default` which is loaded at this point.
    --
    -- 2 materials + 2 fiber = 2 ladders
    -- 1 ladders = 1 ingot
    crafting.register_craft({
        output = registered_ladder..' 2',
        items = {
            material..' 2',
            'rp_default:fiber 2',
        }
    })
    crafting.register_craft({
        output = material..' 1',
        items = {
            registered_ladder..' 1'
        }
    })
end
