local game = ladders_3d.game.id
local modname = ladders_3d.modname


-- Log a status message
--
-- This functions similar to core.log, but automatically prefixes the mod name.
-- If no level is given, `action` is used.
--
-- @param level   One of the supported Luanti log levels
-- @param message The message to log
ladders_3d.log = function (level, message)
    local the_message = message ~= nil and message or level
    local the_level = message == nil and 'action' or level
    core.log(the_level, '[Ladders 3D] '..the_message)
end


-- Get a boolean configuration value or return a default
--
-- This function takes an unprefixed value, automatically prefixes it with the
-- mod name and game and tries to get the boolean value from the configuration
-- (either global or the world-specific)
--
-- my_option → ladders_3d_game_my_option
--
-- If `universal` (3rd parameter in function call) is boolean true, then the
-- option is not prefixed by the game. 
--
-- my_option → ladders_3d_my_option
--
-- If the option is not found in any of the possible configuration locations,
-- the given default value is returned instead.
--
-- @param value     Unprefixed boolean option to get
-- @param default   Default boolean value in case the option is not found
-- @param universal Do not prefix with game name (i.e. independent of game)
--
-- @return boolean The value as requested, or the provided default value
ladders_3d.option = function (short_name, default, universal)
    local option_name = modname
        ..(universal and '' or '_'..game)
        ..'_'..short_name

    local global_value = core.settings:get_bool(option_name, default)
    local world_value = ladders_3d.worldconfig:get_bool(option_name)
    local value = world_value or global_value

    ladders_3d.log('verbose', ('Fetching +t setting: +o = +v'):gsub('%+%w+', {
        ['+t'] = universal and 'mod' or 'specific',
        ['+o'] = option_name,
        ['+v'] = value and 'true' or 'false'
    }))

    return value
end
