-- vim:nowrap


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register


local t = function (texture, opacity)
    return ('(([combine:14x14:-1,-1=+t)^[resize:16x16)^(+m^[opacity:+o)'):gsub('%+%w+',{
        ['+t'] = texture,
        ['+m'] = 'ladders_3d_asuna_shading_mask.png',
        ['+o'] = opacity or 64
    })
end


mass_register({
    groups = { cracky = 2 },
    sounds = core.registered_nodes['default:steelblock'].sounds,
    shading = 0,
    ladders = {
        default_bronze = { S('Bronze Ladder'), 'default:bronze_ingot', t('default_bronze_block.png')     },
        default_copper = { S('Copper Ladder'), 'default:copper_ingot', t('default_copper_block.png')     },
        default_gold   = { S('Golden Ladder'), 'default:gold_ingot',   t('default_gold_block.png', 32)   },
        default_steel  = { S('Steel Ladder'),  'default:steel_ingot',  t('default_steel_block.png', 128) },
        default_tin    = { S('Tin Ladder'),    'default:tin_ingot',    t('default_tin_block.png')        }
    }
})
