-- vim:nowrap


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register
local cut = ladders_3d.cut_texture


local t = function (texture)
    return ('((+t^((+b)^[mask:+c))^(+s^[opacity:+o))'):gsub('%+%w', {
        ['+t'] = texture,
        ['+b'] = 'default_ladder.png',
        ['+c'] = 'ladders_3d_hades_revisited_connectors_mask.png',
        ['+s'] = 'ladders_3d_hades_revisited_metal_ladders_shading_mask.png',
        ['+o'] = 96
    })
end


mass_register({
    groups = { cracky = 3, ladder = 1 },
    sounds = core.registered_nodes['hades_core:ladder_bronze'].sounds,
    shading = 0,
    nodebox = {
        {-0.375, -0.5, 0.375, -0.25, 0.5, 0.5},      -- strut_l
        {0.25, -0.5, 0.375, 0.375, 0.5, 0.5},        -- strut_r
        {-0.25, 0.3125, 0.375, 0.25, 0.4375, 0.5},   -- rung_1
        {-0.25, 0.0625, 0.375, 0.25, 0.1875, 0.5},   -- rung_2
        {-0.25, -0.1875, 0.375, 0.25, -0.0625, 0.5}, -- rung_3
        {-0.25, -0.4375, 0.375, 0.25, -0.3125, 0.5}  -- rung_4
    },
    ladders = {
        -- Bronze ladder already registered by the game
        ladder_copper = { S('Copper Ladder'), 'hades_core:copper_ingot', t(cut('default_copper_block.png'))  },
        ladder_gold   = { S('Golden Ladder'), 'hades_core:gold_ingot',   t(cut('default_gold_block.png'))    },
        ladder_iron   = { S('Iron Ladder'),   'hades_core:iron_ingot',   t(cut('hades_core_iron_block.png')) },
        ladder_steel  = { S('Steel Ladder'),  'hades_core:steel_ingot',  t(cut('default_steel_block.png'))   },
        ladder_tin    = { S('Tin Ladder'),    'hades_core:tin_ingot',    t(cut('default_tin_block.png'))     }
    }
})
