local cut = ladders_3d.cut_texture


local ladders = {
    ladder             = { 'default_ladder.png',                cut('default_wood.png') },
    ladder_bronze      = { 'hades_core_ladder_bronze.png',      cut('default_bronze_block.png', 3) },
    ladder_cream_wood  = { 'hades_core_ladder_cream_wood.png',  cut('hades_trees_cream_wood.png') },
    ladder_jungle_wood = { 'hades_core_ladder_jungle_wood.png', cut('default_junglewood.png') },
    ladder_lush_wood   = { 'hades_core_ladder_lush_wood.png',   cut('hades_trees_lush_wood.png') },
    ladder_pale_wood   = { 'hades_core_ladder_pale_wood.png',   cut('hades_trees_pale_wood.png') }
}


local node_box = {
    type = 'fixed',
    fixed = {
        {-0.375, -0.5, -0.5, -0.25, -0.375, 0.5}, -- strut_l
        {0.25, -0.5, -0.5, 0.375, -0.375, 0.5}, -- strut_r
        {-0.25, -0.5, 0.3125, 0.25, -0.375, 0.4375}, -- rung_1
        {-0.25, -0.5, 0.0625, 0.25, -0.375, 0.1875}, -- rung_2
        {-0.25, -0.5, -0.1875, 0.25, -0.375, -0.0625}, -- rung_3
        {-0.25, -0.5, -0.4375, 0.25, -0.375, -0.3125}, -- rung_4
    }
}


local selection_box = {
    type = 'wallmounted',
    wall_top    = {-0.4375, 0.375, -0.5,    0.4375, 0.5,    0.5},
    wall_side   = {-0.5,    -0.5,  -0.4375, -0.375, 0.5,    0.4375},
    wall_bottom = {-0.4375, -0.5,  -0.5,    0.4375, -0.375, 0.5}
}


-- Iterate over the ladders and replace them with a custom nodebox
for id,def in pairs(ladders) do
    core.override_item('hades_core:'..id, {
        tiles = { def[1], def[1], def[2], def[2], def[2], def[2] },
        use_texture_alpha = 'clip',
        drawtype = 'nodebox',
        paramtype = 'light',
        node_box = node_box,
        selection_box = selection_box
    })
end
