-- vim:nowrap


local S = ladders_3d.translator
local mass_register = ladders_3d.mass_register
local cut = ladders_3d.cut_texture


local t = function (texture)
    return ('((+t^((+b)^[mask:+c))^(+s^[opacity:+o))'):gsub('%+%w', {
        ['+t'] = texture,
        ['+b'] = 'default_ladder.png',
        ['+c'] = 'ladders_3d_hades_revisited_connectors_mask.png',
        ['+s'] = 'ladders_3d_hades_revisited_shading_mask.png',
        ['+o'] = 64
    })
end


mass_register({
    groups = {
        choppy = 3,
        flammable = 2,
        ladder = 1,
        ladder_wood = 1,
        oddly_breakable_by_hand = 3,
    },
    nodebox = {
        {-0.375, -0.5, 0.375, -0.25, 0.5, 0.5},      -- strut_l
        {0.25, -0.5, 0.375, 0.375, 0.5, 0.5},        -- strut_r
        {-0.25, 0.3125, 0.375, 0.25, 0.4375, 0.5},   -- rung_1
        {-0.25, 0.0625, 0.375, 0.25, 0.1875, 0.5},   -- rung_2
        {-0.25, -0.1875, 0.375, 0.25, -0.0625, 0.5}, -- rung_3
        {-0.25, -0.4375, 0.375, 0.25, -0.3125, 0.5}  -- rung_4
    },
    shading = 0,
    ladders = {
        ladder_charred_wood       = { S('Charred Wood Ladder'),           'hades_trees:charred_wood',       t('hades_trees_charred_wood.png')                    },
        ladder_colwood_black      = { S('Black Canvas Wood Ladder'),      'hades_trees:colwood_black',      t('hades_trees_colwood_black.png^[transformFY')      },
        ladder_colwood_blue       = { S('Blue Canvas Wood Ladder'),       'hades_trees:colwood_blue',       t('hades_trees_colwood_blue.png^[transformFY')       },
        ladder_colwood_brown      = { S('Brown Canvas Wood Ladder'),      'hades_trees:colwood_brown',      t('hades_trees_colwood_brown.png^[transformFY')      },
        ladder_colwood_cyan       = { S('Cyan Canvas Wood Ladder'),       'hades_trees:colwood_cyan',       t('hades_trees_colwood_cyan.png^[transformFY')       },
        ladder_colwood_dark_green = { S('Dark Green Canvas Wood Ladder'), 'hades_trees:colwood_dark_green', t('hades_trees_colwood_dark_green.png^[transformFY') },
        ladder_colwood_dark_grey  = { S('Dark Grey Canvas Wood Ladder'),  'hades_trees:colwood_dark_grey',  t('hades_trees_colwood_dark_grey.png^[transformFY')  },
        ladder_colwood_green      = { S('Green Canvas Wood Ladder'),      'hades_trees:colwood_green',      t('hades_trees_colwood_green.png^[transformFY')      },
        ladder_colwood_grey       = { S('Grey Canvas Wood Ladder'),       'hades_trees:colwood_grey',       t('hades_trees_colwood_grey.png^[transformFY')       },
        ladder_colwood_magenta    = { S('Magenta Canvas Wood Ladder'),    'hades_trees:colwood_magenta',    t('hades_trees_colwood_magenta.png^[transformFY')    },
        ladder_colwood_orange     = { S('Orange Canvas Wood Ladder'),     'hades_trees:colwood_orange',     t('hades_trees_colwood_orange.png^[transformFY')     },
        ladder_colwood_pink       = { S('Pink Canvas Wood Ladder'),       'hades_trees:colwood_pink',       t('hades_trees_colwood_pink.png^[transformFY')       },
        ladder_colwood_red        = { S('Red Canvas Wood Ladder'),        'hades_trees:colwood_red',        t('hades_trees_colwood_red.png^[transformFY')        },
        ladder_colwood_uncolored  = { S('Uncolored Canvas Wood Ladder'),  'hades_trees:colwood_uncolored',  t('hades_trees_colwood_uncolored.png^[transformFY')  },
        ladder_colwood_violet     = { S('Violet Canvas Wood Ladder'),     'hades_trees:colwood_violet',     t('hades_trees_colwood_violet.png^[transformFY')     },
        ladder_colwood_white      = { S('White Canvas Wood Ladder'),      'hades_trees:colwood_white',      t('hades_trees_colwood_white.png^[transformFY')      },
        ladder_colwood_yellow     = { S('Yellow Canvas Wood Ladder'),     'hades_trees:colwood_yellow',     t('hades_trees_colwood_yellow.png^[transformFY')     }
    }
})
