local def = core.registered_items['mcl_core:ladder']


core.override_item('mcl_core:ladder', {
    tiles = {
        'default_ladder.png',                 -- top (front)
        'default_ladder.png^[transformR180',  -- bottom (back)
        'default_wood.png^[transformFY',      -- right
        'default_wood.png^[transformFY',      -- left
        'default_wood.png',                   -- back (top)
        'default_wood.png',                   -- bottom
    },
    use_texture_alpha = 'clip',
    drawtype = 'nodebox',
    paramtype = 'light',
    node_box = {
        type = 'fixed',
        fixed = {
            -- Nodebox is laying down due to how it’s registered
            { -0.375, -0.5, -0.5, -0.25, -0.375, 0.5 },       -- strut_l
            { 0.25, -0.5, -0.5, 0.375, -0.375, 0.5 },         -- strut_r
            { -0.4375, -0.5, 0.25, 0.4375, -0.375, 0.375 },   -- rung_top
            { -0.4375, -0.5, -0.25, 0.4375, -0.375, -0.125 }, -- rung_bottom
            { -0.25, -0.5, 0.125, -0.1875, -0.375, 0.25 },    -- holder_tl
            { 0.1875, -0.5, 0.125, 0.25, -0.375, 0.25 },      -- holder_tr
            { -0.25, -0.5, -0.375, -0.1875, -0.375, -0.25 },  -- holder_bl
            { 0.1875, -0.5, -0.375, 0.25, -0.375, -0.25 },    -- holder_br
        }

    },
    selection_box = {
        type = 'wallmounted',
        wall_top    = {-0.4375, 0.375, -0.5,    0.4375, 0.5,    0.5},
        wall_side   = {-0.5,    -0.5,  -0.4375, -0.375, 0.5,    0.4375},
        wall_bottom = {-0.4375, -0.5,  -0.5,    0.4375, -0.375, 0.5}
    }
})
