-- Return a named table with timings
--
-- Convert a value of seconds into a table with named time units for easier
-- referencing where needed. The seconds value is converted to days, hours,
-- minutes and seconds.
--
-- @param seconds An integer representing a seconds value
-- @return table  The converted seconds value as named times table
playtime_limit.convert_seconds = function (seconds)
    return {
        days = string.format('%02d', math.floor(seconds/86400)),
        hours = string.format('%02d', math.floor((seconds % 86400)/3600)),
        minutes = string.format('%02d', math.floor((seconds % 3600)/60)),
        seconds = string.format('%02d', math.floor((seconds % 60)))
    }
end
