local pl = playtime_limit
local S = playtime_limit.translator
local get_player_by_name = core.get_player_by_name
local c = core.chat_send_player


-- Register /playtimne_limit_set chat command
--
-- The chat command can be used to alter a player’s playtime limit and reset
-- interval on-the-fly.
--
-- /playtime_limit_set MyCoolPlayer limit 1200
-- -> Limit the playtime of “MyCoolPlayer” to 20 minutes. If the limit is
--    already reached or passed the player will be disconnected on the next
--    validity check step.
--
-- /playtime_limit_set MyCoolPlayer limit -1
-- -> Disable playtime limit for “MyCoolPlayer”. The player will not receive
--    any further playtime notifications. If re-enabling with another value
--    the player might get kicked because the join timestamp is used to
--    determine the playtime.
--
-- /playtime_limit_set MyCool Player interval 43200
-- -> Set the playtime reset interval to 12 hours. After those 12 hours the
--    player can reconnect after being disconnected. On reconnec the playtime
--    counter is reset.
core.register_chatcommand('playtime_limit_set', {
    params = '<name> <limit/interval> <value>',
    description = S('Set playtime limits and intervals'),
    privs = { server = true },
    func = function (caller, parameters)
        local pt= {}
        for p in parameters:gmatch("%S+") do table.insert(pt, p) end
        local name = pt[1] or '.'
        local setting = pt[2] or '.'
        local value = pt[3] or '.'

        -- Technical validation
        if name == '.' or setting == '.' or value == '.' then return end
        local player = get_player_by_name(name)
        if not player then return end

        -- Configure the limit for the given player
        if setting == 'limit' then
            local meta = player:get_meta()
            meta:set_string(pl.meta.limit.key, value)
            c(caller, S('Playtime limit for @1 set to @2', name, value))
        end

        -- Configure the interval for the given player
        if setting == 'interval' then
            local meta = player:get_meta()
            meta:set_string(pl.meta.interval.key, value)
            c(caller, S('Playtime reset interval for @1 set to @2', name,value))
        end
    end
})

