-- Get needed paths
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)..DIR_DELIM
local syspath = modpath..'system'..DIR_DELIM

local s = core.settings


-- Create table in global namespace
playtime_limit = {
    translator = core.get_translator(modname),
    step_size = tonumber(s:get(modname..'_step_size') or 60),
    meta = {
        start = {
            default = 0,
            key = modname..':session_start'
        },
        limit = {
            default = tonumber(s:get(modname..'_default_limit') or 1800),
            key = modname..':playtime_limit'
        },
        interval = {
            default=tonumber(s:get(modname..'_default_interval') or 86400),
            key = modname..':reset_interval'
        },
        playtime = {
            default = 0,
            key = modname..':current_playtime'
        }
    }
}


-- Load mod back-end
dofile(syspath..'helpers.lua')
dofile(syspath..'validate_player.lua')
dofile(syspath..'player_actions.lua')

-- Load activities
dofile(syspath..'on_joinplayer.lua')
dofile(syspath..'register_globalstep.lua')
dofile(syspath..'register_chatcommand.lua')

-- Remove global table
playtime_limit = nil
