local pl = playtime_limit
local trigger = 0
local step = pl.step_size


-- Register playtime counter change on global step if the trigger value
-- reached the step size (by default 60 seconds). This is as accurate as
-- the server’s globalstep.
core.register_globalstep(function(dtime)
    trigger = trigger + dtime

    -- Run playtime checks for all players after a minute haspassed
    if trigger >= step then
        trigger = 0
        for _,player in pairs(core.get_connected_players()) do
            if not player then return end
            local player_name = player:get_player_name()

            -- Change and validate player
            pl.change_playtime_counter(player_name, step)
            local val = pl.validate_player(player_name)

            -- Inform player when there are only 5 validation steps left. A
            -- step is 60 seconds. The information is only sent if the limit
            -- is not -1 (disabled)
            if val.remaining_time < 5*step and val.data.limit ~= -1  then
                pl.inform_player(val)
            end

            -- Disconnect player if the limit is reached. The player is only
            -- disconnected if the limit is not -1 (disabled)
            if val.limit_reached == true and val.data.limit ~= -1 then
                pl.disconnect_player(val)
            end
        end
    end
end)
