local pl = playtime_limit


-- When a player joined the following steps are taken in this order:
--
-- 1. Validate if the player is an actual player
-- 2. Validate if the player has the needed meta data set and set if not
-- 3. Check if the playtime reset interval is reached and if so: reset
-- 4. Validate if the player is within the playtime limit
-- 5. Either disconnect or inform about remaining time, depending on step 4.
core.register_on_joinplayer(function(player)
    if not player then return end
    local player_name = player:get_player_name()
    local meta = player:get_meta()
    local timestamp = os.time()

    -- Player was never online before! Set all needed meta data values for
    -- any further calculations. We unify all calculations based on meta data
    -- and do not handle new players differently from recurring players and
    -- thus we set all meta data first.
    if not meta:get(pl.meta.start.key) then
        meta:set_string(pl.meta.start.key, timestamp)
        meta:set_string(pl.meta.limit.key, pl.meta.limit.default)
        meta:set_string(pl.meta.interval.key, pl.meta.interval.default)
        meta:set_string(pl.meta.playtime.key, pl.meta.playtime.default)
    end

    -- Fetch relevant timings
    local start = meta:get(pl.meta.start.key)
    local interval = meta:get(pl.meta.interval.key)

    -- Check if reset interval is reached and reset playtime and set start
    -- timestamp for beginning a new session.
    if timestamp > start+interval then
        start = timestamp
        meta:set_string(pl.meta.start.key, timestamp)
        meta:set_string(pl.meta.playtime.key, pl.meta.playtime.default)
    end

    -- Get Validity table and disconnect player if limit is reached
    local validity = pl.validate_player(player_name)
    if validity.limit_reached == true and validity.data.limit ~= -1 then
        pl.disconnect_player(validity)
    end

    -- At this point the player is allowed to play on the server.
    if validity.data.limit ~= -1 then pl.inform_player(validity) end
end)
