local pl = playtime_limit
local get_player_by_name = core.get_player_by_name


-- Validate a player
--
-- The function calculates the playtime limit, the remaining time, and the
-- session reset time and returns those values and all meta data values for
-- validation if the player needs to be disconnected.
--
-- @param player_name The name of the player to return the validation table for
playtime_limit.validate_player = function (player_name)
    local player = get_player_by_name(player_name)
    if not player then return end
    local meta = player:get_meta()
    local timestamp = os.time()

    -- Fetch current timings
    local start = tonumber(meta:get(pl.meta.start.key))
    local limit = tonumber(meta:get(pl.meta.limit.key))
    local interval = tonumber(meta:get(pl.meta.interval.key))
    local playtime = tonumber(meta:get(pl.meta.playtime.key))

    return {
        data = {
            start = start,
            limit = limit,
            interval = interval,
            playtime = playtime,
        },
        player_name = player_name,
        limit_reached = playtime >= limit,
        session_reset = start + interval,
        remaining_time = limit - playtime
    }

end
