_**Modify adjacent nodes with one click to build walls.**_

When building larger structures in Luanti games with building focus you might find yourself in a situation where you might want to raise up a line of nodes to build some sort of wall.

![Effect of using the trowel on a wall in “Minetest Game”](doc/screenshots/trowel_modification_minetest_game.gif)

A trowel or brick trowel is a brick mason’s tool that is used for building walls – and this mod implements one, so you can build walls, too.

The mod respects creative/survival modes.

For in-depth information on the functionality of the registered tool, and configuration for servers and API usage, see the [advanced configuration readme](doc/README.advanced.md).

## Obtaining the trowel

By default the trowel can be obtained either by crafting or by invoking a chat command if there is not craft recipe being registered. This can be changed by games. If neither of the methods work in your game, check the game’s instructions.

### Craft recipe

The craft recipe shape is always the same. The needed items are depending on the game.

![Craft recipe as shown in “Minetest Game”](doc/screenshots/trowel_crafting_minetest_game.png)

*Crafting the tool in “Minetest Game”*

It is always something *iron-y* for the plate, something *stick-y* for the shaft and something *handle-y* for the handle (either handle material like leather or something you could wrap around a stick to get a handle – like a string for example).

#### Games with craft recipe

The following games have a craft recipe registered. Consult your game’s craft recipes overview for details on what materials are needed.

* Asuna
* Mesecraft
* Mineclonia
* Minetest Game
* VoxeLibre

Feel free to suggest games to add (as well as the materials to use for the plate, the shaft, and the handle) in the [CDB][cdb] or [the forums][forums].

### Chat Command

If the game has no craft recipe materials assigned (or the assigned materials are invalid) a chat command is registered instead. With this chat command you can obtain a trowel for free.

```
/trowel giveme
```

Other than that, the trowel behaves the same as if it was crafted.

## Translations

Missing your language? Feel free to add it!

[![Translation status](https://translate.codeberg.org/widget/linuxdirks-luanti-mods/trowel/287x66-grey.png)](https://translate.codeberg.org/projects/linuxdirks-luanti-mods/trowel)

<!-- To be added -->
[cdb]: /
[forums]: /
