local S = trowel.translator
local tool_id = trowel.tool_id
local game = core.get_game_info().id
local log = core.log


local chatcommand = trowel.advanced.chatcommand
local craft_recipe = trowel.advanced.craft_recipe


-- Game items registration
--
-- | Game ID    | Game Name     | CDB                  |
-- |------------|---------------|----------------------|
-- | asuna      | Asuna         | EmptyStar/asuna      |
-- | mesecraft  | Mesecraft     | MeseCraft/mesecraft  |
-- | mineclone2 | VoxeLibre     | Wuzzy/mineclone2     |
-- | mineclonia | Mineclonia    | ryvnf/mineclonia     |
-- | minetest   | Minetest Game | Luanti/minetest_game |
--
-- game_id = { plate, shaft, handle }
local items = {
    asuna = { 'default:steel_ingot', 'default:stick', 'animalia:leather' },
    mesecraft={'default:steel_ingot','default:stick','mesecraft_mobs:leather'},
    mineclone2={'mcl_core:iron_ingot','mcl_core:stick','mcl_mobitems:string'},
    mineclonia={'mcl_core:iron_ingot','mcl_core:stick','mcl_mobitems:string'},
    minetest = { 'default:steel_ingot', 'default:stick', 'farming:string' }
}


-- If the server runs one of the above games, make the tool craftable.
if items[game] then

    if craft_recipe == false then
        log('info', '[trowel] Not registering craft recipe')
        return
    else
        log('verbose', '[trowel] Registering craft recipe')
    end

    core.register_craft({
        output = tool_id,
        recipe = {
            { ''             , items[game][2] , items[game][3] },
            { ''             , items[game][2] , ''             },
            { items[game][1] , items[game][1] , ''             }
        },
    })
else
    log('info', '[trowel] Game ID `'..game..'` has no craft recipe')
end


-- If the tool is not craftable, and the fallback chat command is allowed,
-- register the `/trowel giveme` command so players can request a tool manually.
--
-- Only players with `interact` privilege are allowed to run the command.
if not items[game] then

    if chatcommand == false then
        log('info', '[trowel] Not registering fallback chat command')
        return
    else
        log('info', '[trowel] Registering fallback chat command')
    end

    core.register_chatcommand('trowel', {
        params = 'giveme',
        privs = { interact = true },
        description = S('Invoke @1 to get a brick trowel',
            core.colorize('#888a85', '/trowel giveme')
        ),
        func = function (name, param)
            local player = core.get_player_by_name(name)
            if not player:is_player() then return end

            if param == 'giveme' then
                local inv = player:get_inventory()
                if inv:room_for_item('main', tool_id) then
                    inv:add_item('main', tool_id)
                    log('info', '[trowel] '..name..' received '..tool_id)
                else
                    core.chat_send_player(name, S('Your inventory is full!'))
                end
            end

        end
    })

    log('verbose', '[trowel] Use `/trowel giveme` for obtaining the tool')
end
