local modname  = core.get_current_modname()
local system   = core.get_modpath(modname)..DIR_DELIM..'system'..DIR_DELIM
local settings = core.settings


-- Base settings
trowel = {
    translator = core.get_translator(modname),
    max_distance = tonumber(settings:get('trowel_max_distance') or 10),
    tool_id = 'trowel:trowel',
    single_node_wear = tonumber(settings:get('trowel_single_node_wear') or 100),
    advanced = {
        chatcommand = settings:get_bool('trowel_use_fallback_chatcommand',true),
        craft_recipe = settings:get_bool('trowel_register_craft_recipe', true),
        apify_mod = settings:get_bool('trowel_apify_mod_functionality', false),
        register_tool = settings:get_bool('trowel_register_tool_item', true)
    }
}


-- Mod functionality
dofile(system..'modify_wall.lua')
dofile(system..'register_tool.lua')
dofile(system..'register_craft.lua')


-- Optional APIfication
if trowel.advanced.apify_mod == true then
    trowel = { modify_wall = trowel.modify_wall }
else
    trowel = nil
end
