## Tool craft recipe registration

During mod loading stage the mod fetches the game ID the server is running with. If it is one of the manually supported games, a craft recipe for the tool is made available.

```text
┏━━━┯━━━┯━━━┓
┃   │ S │ H ┃
┠───┼───┼───┨
┃   │ S │   ┃
┠───┼───┼───┨
┃ P │ P │   ┃
┗━━━┷━━━┷━━━┛
```

* P → plate
* S → shaft
* H → handle

Depending on the game, the materials differ. All craft recipes use very basic materials that should be easily collectable during normal gameplay. In [register_craft.lua](../system/register_craft.lua) the materials for the different games are defined.

If there are no materials defined for the currently running game are defined, a chat command is registered instead. By invoking `/trowel giveme` the player will be give one tool if the player has the `interact` privilege set.

*If you run a server and find your game unsupported, feel free to drop me a note in the forums or the CDB and let me know. I’d be happy to add a materials definition.*

## Wall detection logic

When a player clicks on a node (either with the place button or the use button), this node is used as reference node. This reference node’s ID and position are then transferred to the validation logic. The logic first checks if the reference node is a valid node. A valid node is a node that has the same ID as the reference node and where no node placed above it.

All adjacent nodes within a maximum length on the X axis are validated, too. If a node is not valid on the X axis, the validation logic for that direction stops, and then the other direction on the X axis is validated until the maximum length is reached or a node is invalid.

This is repeated for the Z axis, too. It is then checked which of the two resulting node tables is longer (i.e. contains more nodes). The longer table is then used as wall to modify. If both tables are of same length, the X axis wall takes precedence.

![Different validation results](screenshots/trowel_validation_results.png)

* blue → The currently pointed at node that is used as reference
* green → Valid nodes: same ID and air above
* orange → Invalid nodes: different ID (and also no air above)

## Configuration

The tool works the same for all players and cannot be individually configured. There are server-wide configuration options. Those optionas are also available in the Luanti client’s configuration.

```
trowel_max_distance = 10
trowel_single_node_wear = 100
```

The `trowel_max_distance` value defines how many nodes are scanned. There are two scans made, one on the X axis and one on the Z axis. Both scans extend up to this value from the `pointed_thing` (used as reference node as described above).

With the default settings, on each click a maximum of 41 nodes are scanned. This works nearly-instant on a local singleplayer server.

With `trowel_single_node_wear` you can configure how much wear is added to the tool item if a player is not in creative mode. This value is multiplied by the amount of nodes that will be modified on this use. So when the detected wall has 23 nodes, by default 2300 wear points are added.

Maximum wear as per Luanti API is 65535, so a total of 656 nodes can be modified with the tool before it breaks.

## Custom implementation (advanced configuration)

The mod can be used as-is and most likely fits a player’s needs and also most “open world voxel sandbox game” servers. The settings that can be changed in the client’s configuration should be enough for most use cases.

There are more settings for advanced configuration that are special use-case and are not represented in the client’s configuration for this exact reason.

```
trowel_use_fallback_chatcommand = true
trowel_register_craft_recipe = true
trowel_apify_mod_functionality = false
trowel_register_tool_item = true
```

As described before, the mod generates a chat command for obtaining the tool when the game has no crafting materials defined. To prevent this, you can set `trowel_use_fallback_chatcommand` to `false`. This will result in not creating the chat command even if the game has no crafting materials defined.

With `trowel_register_craft_recipe` you can control if a crafting recipe should be registered. If you set it to `false`, a craft recipe is not being registered, even if the game has crafting materials set.

By default, the global table used internally to exchange functions and data between parts of the mod will be removed, after the mod was loaded to clean up the global namespace. By setting `trowel_apify_mod_functionality` to `true`, the table will become an API for implementing own tools.

A tool (*Brick Trowel*) will be registered regardless of all of the advanced settings. To prevent this, you can set `trowel_register_tool_item` to `false`. This results in no tool being registered.

```
trowel_use_fallback_chatcommand = false
trowel_register_tool_item = false
trowel_register_craft_recipe = false
trowel_apify_mod_functionality = true
```

This results in the mod becoming an API without adding any own tools or chat commands.

### API usage

To use the API, you need to (opt-)depend on the mod. You then have access to `trowel.modify_wall()`. This API function takes three parameters.

```lua
trowel.modify_wall(
    player,        -- Player ObjectRef as per Luanti API
    pointed_thing, -- A `pointed_thing` table as per Luanti API
    direction      -- 1 or -1 as directional value (1 = up, -1 = down)
)
```

The function validates if the `player` object refers to an actual player. If not, the function immediately returns `nil`. The function also returns `nil` if the `pointed_thing` refers to an invalid node (see above).

If in creative mode, `nil` is returned after the wall was modified. In non-creative mode, the function returns a modified `ItemStack` as per Luanti API. This `ItemStack` has the wear value added to the tool.
