local S = trowel.translator
local modify_wall = trowel.modify_wall
local tool_id = trowel.tool_id
local register_tool = trowel.advanced.register_tool


if register_tool == true then
    core.register_tool(tool_id, {
        short_description = S('Brick Trowel'),
        inventory_image = 'trowel_trowel.png',
        wield_image = 'trowel_trowel.png^[transformR270',

        description = table.concat({
            S('Brick Trowel'),
            '',
            S('Build to raise the wall'),
            S('Dig to lower the wall'),
        }, '\n'),

        on_place = function(i,u,pt) return modify_wall(u, pt, 1) end, -- Place
        on_use = function(i,u,pt) return modify_wall(u, pt, -1) end   -- Mine
    })
else
    core.log('info', '[trowel] Not registering tool')
end
