local modname   = core.get_current_modname()
local inventory = core.get_modpath(modname)..DIR_DELIM..'inventory'..DIR_DELIM
local dirlist   = core.get_dir_list


-- Predefine relevant things
void_inventory = {
    modname    = modname,
    translator = core.get_translator(modname),
    formspecs  = {},
    helpers    = {},
    ids = {
        all_items      = modname..':all_items',
        cooking_source = modname..':cooking_source',
        cooking_result = modname..':cooking_result',
        repair_source  = modname..':repair_source',
        repair_result  = modname..':repair_result',
        edit_formspec  = modname..':edit_data'
    }
}


-- Load helper functions
for _,file in pairs(dirlist(inventory..'helpers', false)) do
    dofile(inventory..'helpers'..DIR_DELIM..file)
end


-- Register formspec functions
for _,file in pairs(dirlist(inventory..'formspecs', false)) do
    dofile(inventory..'formspecs'..DIR_DELIM..file)
end


-- Handle inventory fields
for _,file in pairs(dirlist(inventory..'fields', false)) do
    dofile(inventory..'fields'..DIR_DELIM..file)
end


-- Run actions after all mods were loaded
core.register_on_mods_loaded(function ()
    for _,file in pairs(dirlist(inventory..'actions', false)) do
        dofile(inventory..'actions'..DIR_DELIM..file)
    end
end)
