local ids = void_inventory.ids
local fs  = void_inventory.formspecs
local h   = void_inventory.helpers


-- Set player inventory formspec and add items to inventory
core.register_on_joinplayer(function(player)
    if not player:is_player() then return end

    local name  = player:get_player_name()
    local inv   = core.get_inventory({ type = 'player', name = name })
    local items = h.get_all_items()

    -- Load all IDs or valid items into the items table and set up the
    -- items inventory list
    inv:set_size(ids.all_items, items.size)
    inv:set_list(ids.all_items, items.list)

    -- Set up cooking inventories
    inv:set_size(ids.cooking_source, 1)
    inv:set_size(ids.cooking_result, 1)

    -- Set up tool repair inventories
    inv:set_size(ids.repair_source, 2)
    inv:set_size(ids.repair_result, 1)

    -- Set inventory formspec with the given size
    player:set_inventory_formspec(fs.inventory(items.size))
end)


-- Set nodes inventory permissions
--
-- When something is done with the extra inventories as target or source
core.register_allow_player_inventory_action(function(player, action, inv, info)
    if info.listname  == ids.all_items      then return -1 end -- take from
    if info.to_list   == ids.all_items      then return -1 end -- move into
    if info.from_list == ids.all_items      then return -1 end -- move out of
    if info.to_list   == ids.cooking_result then return  0 end -- move into
    if info.to_list   == ids.repair_result  then return  0 end -- move into
end)


-- Handle node inventory actions
core.register_on_player_inventory_action(function(player, action, inv, i)

    -- Moving something from the nodes inventory into another inventory
    if i.from_list == ids.all_items and action == 'move' then
        local item = inv:get_stack(i.from_list, i.from_index):get_name()
        local count = inv:get_stack(i.to_list, i.to_index):get_count()+1
        inv:set_stack(i.to_list, i.to_index, item..' '..count)
    end

    -- Moving something into the nodes inventory
    if i.to_list == ids.all_items and action == 'move' then
        local item = inv:get_stack(i.from_list, i.from_index)
        local count = item:get_count() - i.count
        inv:set_stack(i.from_list, i.from_index, item:get_name()..' '..count)
    end

    -- If a player takes something out of the cooking source or result slot,
    -- set flag to run the place action again to maybe refill the slot
    local check_cooking = false
    if i.from_list == ids.cooking_result then check_cooking = true end
    if i.from_list == ids.cooking_source then check_cooking = true end
    if i.to_list   == ids.cooking_source then check_cooking = true end

    -- Check if there is something to cook when the player interacts with any
    -- if the both cooking-related inventories.
    if check_cooking == true then
        local source_item = inv:get_stack(ids.cooking_source, 1)

        local result = core.get_craft_result({
            method = 'cooking',
            width = 1,
            items = { source_item }
        })

        if result.item:get_name() == '' then
            inv:set_list(ids.cooking_result, {})
            return
        end

        inv:set_list(ids.cooking_result, { result.item })
    end

    -- If a player interacts with the tool repair inventory, always run the
    -- action to check for tool repairs
    local check_repair = false
    if i.from_list == ids.repair_result then check_repair = true end
    if i.from_list == ids.repair_source then check_repair = true end
    if i.to_list   == ids.repair_source then check_repair = true end

    -- Handle tool repair
    if check_repair then
        local source1 = inv:get_stack(ids.repair_source, 1)
        local source2 = inv:get_stack(ids.repair_source, 2)

        local result = core.get_craft_result({
            method = 'toolrepair',
            width = 2,
            items = { source1, source2 }
        })

        if result.item:get_definition().type ~= 'tool'
            or result.item:get_name() == ''
            or source1:get_name() == '' or source2:get_name() == ''
        then
            inv:set_list(ids.repair_result, {})
            return
        end

        inv:set_list(ids.repair_result, { result.item })
    end

end)
