local all_items = void_inventory.all_items

local ids = void_inventory.ids
local S   = void_inventory.translator


-- Return an inventory action button
--
-- @param number  index   Horizontal index
-- @param string  name    The name (ID) for that button
-- @param string  texture Icon to use
-- @param string  tooltip Tooltip with the action description
--
-- @return string Formspec string for the button
local button = function (index, name, texture, tooltip)
    return table.concat({
        'tooltip[+name;+tooltip]',
        'image_button[+pos,0;0.5,0.5;+icon;+name;;;false]'
    }, ' '):gsub('%+%w+', {
        ['+pos'] = (index - 1) * 0.5,
        ['+name'] = name,
        ['+tooltip'] = tooltip,
        ['+icon'] = '(('..texture..')^[opacity:128)'
    })
end


-- Get the inventory
--
-- This function generates the player inventory formspec, based on the given
-- `invsize` value (this should be the length of the – filtered – inventory
-- list which needs to be calculated before setting the inventory).
--
-- @param number invsize Size of the inventory to calculate inventory slots
--
-- @return string The player inventory formspec
void_inventory.formspecs.inventory = function (invsize)
    return table.concat({
        'formspec_version[8]',
        'size[20.25,10]',
        'no_prepend[]',
        'bgcolor[#2e3436;both;#2e343550]',
        'listcolors[#babdb650;#eeeeec50;#888a8550]',

        -- Luanti default crafting inventories
        'container[0.25,0.25]',
        '  box[0,0;5.75,4;#888a8530]',
        '  list[current_player;craft;0.25,0.25;3,3;]',
        '  list[current_player;craftpreview;4.5,1.5;1,1;]',
        'container_end[]',

        -- Smelting/Cooking items
        'container[6.25,0.25]',
        '  box[0,0;4.25,1.5;#888a8530]',
        '  list[current_player;+cookingSource;0.25,0.25;1,1;]',
        '  tooltip[1.5,0.5;0.5,0.5;+cookingInfo]',
        '  image[1.5,0.5.25;0.5,0.5;end_icon.png^[opacity:128]',
        '  list[current_player;+cookingResult;2.2,0.25;1,1;]',
        'container_end[]',

        -- Tool repair
        'container[6.25,2]',
        '  box[0,0;4.25,1.5;#888a8530]',
        '  list[current_player;+repairSource;0.25,0.25;2,1;]',
        '  tooltip[2.52,0.5;0.5,0.5;+repairInfo]',
        '  image[2.65,0.61.25;0.25,0.25;checkbox_64.png^[opacity:128]',
        '  list[current_player;+repairResult;3,0.25;1,1;]',
        'container_end[]',

         -- Fucntion buttons
        'container[6.25,3.75]',
        '  box[0,0;4.25,0.5;#888a8530]',
        button(1, 'c_main', 'clear.png',         S('Clear main inventory')),
        button(2, 'c_tool', 'inventory_btn.png', S('Clear “tool inventories”')),
        button(3, 'reload', 'refresh.png',       S('Reload items inventory')),
        button(4, 'edit',   'debug_btn.png',     S('Edit first item data')),
        'container_end[]',

        -- Luanti default player inventory
        'container[0.25,4.5]',
        '  box[0,0;10.25,5.25;#888a8530]',
        '  list[current_player;main;0.25,0.25;8,4;]',
        'container_end[]',

        -- Filter
        'container[10.75,0.25]',
        '  box[0,0;9.25,1;#888a8530]',
        '  field_close_on_enter[filterstring;false]',
        '  style[filterstring;border=false]',
        '  container[0.25,0.25]',
        '    box[0,0;7.5,0.5;#888a8550]',
        '    field[0,0;7.5,0.5;filterstring;;]',
        button(16.5, 'f_filter', 'search.png', S('Filter items inventory')),
        button(17.5, 'f_reset', 'clear.png', S('Reset search filter')),
        '  container_end[]',
        'container_end[]',

        -- All items inventory
        'container[10.75,1.5;8,9.5;all_items;horizontal;;]',
        '  box[0,0;9.25,8.25;#888a8530]',
        '  scrollbar[9,0;0.25,8.25;vertical;all_items;]',
        '  scroll_container[0,0;9,8;all_items;vertical;;0]',
        '    list[current_player;+allItems;0.25,0.25;7,+invsize;]',
        '  scroll_container_end[]',
        'container_end[]',

        -- Listring between all_items and main
        'listring[]',

    }, ' '):gsub('%+%w+', {
        ['+allItems'] = ids.all_items,
        ['+invsize'] = math.ceil(invsize / 7),
        ['+cookingSource'] = ids.cooking_source,
        ['+cookingResult'] = ids.cooking_result,
        ['+cookingInfo'] = S('Cooking/Smelting an item'),
        ['+repairSource'] = ids.repair_source,
        ['+repairResult'] = ids.repair_result,
        ['+repairInfo'] = S('Repair a tool')
    })
end
