*Void Inventory* is an inventory mod for Luanti that allows accessing all registered items from the inventory while preserving all game-defined or standard engine interactions. The inventory mod also does not need any special permissions and work will all engine- or game-defined game modes and privileges.

[![The inventory’s various features shown within “Minetest Game”.](screenshots/void_inventory_minetest_game_small.png)](screenshots/void_inventory_minetest_game.png)

*The inventory’s various features shown within “Minetest Game”.*

The mod is primarily meant to support game or mod development in a clean environment like [Void][VoidGit] ([CDB][VoidCDB], [forums][VoidForums]) but also works as (somewhat specific) creative inventory for other purposes.

The items inventory list shows all items at the same time in a scrollable list. This could cause performance issues if there are a lot of items registered. The items list is only set on join or when requesting a reload, so in general it should work without issues except when it comes to rendering the formspec.

## Features

* **Game-agnostic**: Works with all games that do not modify the inventory.
* **Mode-agnostic**: Works with any engine- or game-defined modes.
* **Privileges-agnostic**: Works regardless engine- or game-defined player privileges
* **Self-contained**: No external dependencies, non-engine textures, other mods, or non-engine APIs.
* **Game-defined interactions**: No modification of node placing or digging or picking up items.
* **Engine main inventory**: Uses the unaltered Luanti default `main` inventory list for the player inventory.
* **Engine craft inventory**: Unaltered Luanti 3x3 crafting inventory with unaltered output.
* **Tool repair inventory**: 1x2 inventory for tools with `toolrepair` recipe, including output.
* **Cooking/Smelting inventory**: One-slot input and output inventory for items with `cooking` recipes.
* **Meta data editing**: Edit meta data of the first item in the `main` inventory list (result depends on engine support).

### Convenience functionality

* **Unlimited takeout**: For easier testing, the repair and smelting “tool inventories” do not remove the input items when taking the output.
* **No crafting changes**: Crafting inventory functionality remains unchanged
* **Clear inventories**: Quick-actions to clear the “tool inventories” and/or the `main` inventory list.
* **Reload items**: “Live-reload” of the *all items* inventory list in case of race conditions with other mods.
* **Items filter**: Allows for filtering all items by case-insensitive original and translated first line of description and short description as well as the ID.

## Item data editing

The inventory allows editing of `ItemStack` meta data as well as wear. For doing so, place an item in the first slot of the `main` inventory list and click the “Edit first item data” button in the inventory. A special formspec is shown, having the currently set values of the first slot item.

[![Editing an axe from “Minetest Game”](screenshots/void_inventory_item_data_editing_small.png)](screenshots/void_inventory_item_data_editing.png)

*Editing an axe from “Minetest Game”*

To change a value, just enter it in the field and press return or click the corresponding “Set this value” button. To remove the value, just set an empty text field. You can also click the corresponding “Remove this value” button.

Please note that all changes to the `ItemStack` data are only set to the ItemStack that is in slot 1 of the `main` inventory list. It is up to the game to use/interpret the data, especially when it comes to placing nodes.

This functionality allows changing all `ItemStackMetaRef` values that are available in the latest stable release of Luanti. It additionally allows setting tool wear, which is not stored as meta data but `ItemStack` value.

The `wear` value is sanitized, all values exact or larger than 65535 are set to 65534, so the item does not get destroyed. Such an item will allow for one use before being destroyed (except the game or a mod calculates wear before using the tool and prevents that).

## Known issues

**When used in combination with mods or games that modify the inventory, unforeseen consequences could happen.**

* It is generally not advised to use *Void Inventory* in normal gameplay or if your environment already has a mod that handles the player inventory using `player:set_inventory_formspec()` or modifies the `main` list in player inventories or implements a custom crafting and/or tool repair or smelting/cooking API.

* When filtering the items and re-opening the inventory, the filter stays active but the filter string is not shown anymore. Same with coming back from the data editing formspec. Also, when resetting the search filter, the filter string is still shown until re-opening the inventory formspec. This is due to how Luanti handles formspecs.

## Translations

Missing your language? Feel free to add it!

[![Translation status](https://translate.codeberg.org/widget/linuxdirks-luanti-mods/void-inventory/287x66-grey.png)](https://translate.codeberg.org/projects/linuxdirks-luanti-mods/void-inventory)

[VoidGit]: https://git.0x7be.net/dirk/void
[VoidCDB]: https://content.luanti.org/packages/Linuxdirk/void/
[VoidForums]: https://forum.luanti.org/viewtopic.php?t=25266
