local get_group = core.get_item_group
local show_formspec = core.show_formspec
local c = core.colorize

local S   = void_inventory.translator
local ids = void_inventory.ids
local fs  = void_inventory.formspecs
local h   = void_inventory.helpers


-- Process player interaction with the inventory formspec (not inventory lists)
core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= '' or not player:is_player() then return end

    local inv   = player:get_inventory()
    local name  = player:get_player_name()
    local enter = fields.key_enter_field

    -- Clear main inventory
    if fields.c_main then
        h.info(name, S('Main inventory was cleared!'))
        inv:set_list('main', {})
    end

    -- Clear tool inventories
    if fields.c_tool then
        h.info(name, S('“Tool inventories” were cleared!'))
        inv:set_list('craft', {})
        inv:set_list(ids.repair_source,  {})
        inv:set_list(ids.repair_result,  {})
        inv:set_list(ids.cooking_source, {})
        inv:set_list(ids.cooking_result, {})
    end

    -- Reloading items inventory
    if fields.reload then
        h.info(name, S('Reloading items inventory …'))
        inv:set_list(ids.all_items, {})
        inv:set_list(ids.all_items, h.get_all_items().list)
        h.info(name, S('Items inventory was reloaded!'))
    end

    -- Open edit formspec if the first slot contains an item
    if fields.edit then
        local stack = inv:get_stack('main', 1)

        if stack:get_name() == '' then
            h.info(name, S('No item in slot 1'))
            return
        end

        local desc = stack:get_short_description() or stack:get_description()

        -- @TRANSLATORS: @1 is the description and @2 is the ID (`mod:item`)
        h.info(name, S('Editing @1 (@2)',
            c('#8ae234', desc),
            c('#babdb6', stack:get_name())
        ))
        show_formspec(name, ids.edit_formspec, fs.edit(name, stack))
    end

    -- Handle filter/search
    if enter == 'filterstring' or fields.f_filter or fields.f_reset then
        local items = {}
        local filterstring = fields.filterstring

        if enter or fields.f_filter then
            items = h.get_all_items(filterstring, name)
            h.info(name, S('Applying items filter: @1', filterstring))
        end

        if fields.f_reset or fields.quit then
            items = h.get_all_items()
            h.info(name, S('Items filter was reset'))
        end

        inv:set_size(ids.all_items, items.size)
        inv:set_list(ids.all_items, {})
        inv:set_list(ids.all_items, items.list)
    end

end)
