local get_group = core.get_item_group
local get_translation = core.get_translated_string


-- Get items
--
-- Collect all items “live” from core.registered_items when called. The items
-- are filtered (`not_in_creative_inventory` as group, and some more filters
-- to hide unusable items).
--
-- result_table = {
--   list = {},   -- Table sorted item IDs to be set as inventory list
--   count = 0,   -- Total count of collected relevant items
--   padding = 0, -- Padding to be divisible by 7 (items inventory width)
--   size = 0     -- Size of the inventory list (count + padding)
--   filter = 0   -- String being used to filter the items
-- }
--
-- @return table Result table as described
void_inventory.helpers.get_all_items = function (filterstring, name)
    local res = {
        list = {},
        count = 0,
        padding = 0,
        size = 0,
        filter = filterstring
    }

    for id,def in pairs(core.registered_items) do
        local hand = id == ''
        local hide = get_group(id, 'not_in_creative_inventory') > 0
        local match_filter = true

        if filterstring and name then
            local locale = core.get_player_information(name).lang_code or ''
            local short_desc = def.short_description or ''
            local description = def.description or ''

            local haystack = table.concat({
                short_desc,
                description:gsub('\n*','') or '',
                get_translation(locale, short_desc),
                (get_translation(locale, description)):gsub('\n*',''),
                id
            }, ' '):lower()

             match_filter = haystack:find(filterstring:lower())
        end

        if not hide and not hand and match_filter then
            table.insert(res.list, id)
            res.count = res.count + 1
        end
    end

    table.sort(res.list)
    res.padding = 7 - (#res.list % 7)
    res.size = res.count + res.padding

    return res
end
