local c = core.colorize
local S = void_inventory.translator

local modname = void_inventory.modname


-- Send a chat message to the player for informational purposes
void_inventory.helpers.info = function(name, message, color, loglevel)
    local prefix = table.concat({
        c('#729fcf', '['),
        c('#babdb6', modname),
        c('#729fcf', ']'),
        ' '
    }, '')

    -- Send chat notification to the player
    local processed_message = color and c(color, message) or message
    core.chat_send_player(name, prefix..processed_message)

    -- Log message to serverlog, too
    if loglevel then
        message = core.get_translated_string('', message)
        message = core.strip_colors(message)
        core.log(loglevel, '@'..name..': '..message)
    end
end
