local get_group = core.get_item_group
local show_formspec = core.show_formspec
local c = core.colorize

local S   = void_inventory.translator
local ids = void_inventory.ids
local fs  = void_inventory.formspecs
local h   = void_inventory.helpers

local items = h.get_all_items()


-- Handle player interaction with the edit meta data fields formspec
core.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= ids.edit_formspec or not player:is_player() then return end

    local inv     = player:get_inventory()
    local name    = player:get_player_name()
    local stack   = inv:get_stack('main', 1)
    local meta    = stack:get_meta()
    local item_id = stack:get_name()

    local action = ''
    local key    = ''
    local value  = ''

    -- Player pressed return-to-inventory button
    if fields.back then
        show_formspec(name, '', fs.inventory(items.size))
        return
    end

    -- Player pressed enter in a field
    if fields.key_enter_field then
        key    = fields.key_enter_field:gsub('^data_', '')
        value  = fields['data_'..key]
        action = 'set'
    end

    -- Player clicked a button
    if not fields.key_enter_field then
        for field,_ in pairs(fields) do
            if field:find('^set_') then
                key    = field:gsub('^set_', '')
                value  = fields['data_'..key]
                action = 'set'
            elseif field:find('^remove_') then
                key    = field:gsub('^remove_', '')
                value  = ''
                action = 'remove'
            end
        end
    end

    -- Item wear is not stored as regular meta data and needs special treatment
    -- here. The value is sanitized to be below the maximum wear level (which
    -- would remove the item)
    if key == 'wear' then
        local wear_number = tonumber(value) or 0
        local sanitized_wear = wear_number <= 65535 and wear_number or 65535
        stack:set_wear(sanitized_wear)
        value = sanitized_wear
    else
        meta:set_string(key, value or '')
    end

    -- Set string and reload formspec
    if action == 'set' or action == 'remove' then
        local scroll = fields.data_fields:gsub('VAL:', '')
        inv:set_stack('main', 1, stack)
        show_formspec(name, formname, fs.edit(name, stack, scroll))

        -- @TRANSLATORS: @1 = key to set, @2 = value, @3 = ID (mod:item)
        h.info(name, S('Setting @1 = @2 for @3',
            c('#babdb6', key),
            value == '' and c('#fcaf3e', S('[empty]')) or c('#8ae234', value),
            c('#babdb6', item_id)
        ), 'action')
    end

end)
