local function olmap (proc, tabl)
   local res = {}
   for k, v in pairs (tabl) do
      res[k] = proc (v)
   end
   return res
end

local function find_item(list, item)
   for i, v in ipairs (list) do
      if v == item then
	 return i
      end
   end
   return nil
end

minetest.register_privilege("manhunt_admin", {  
			       description = "Manage manhunts with /manhunt <option>."
})


minetest.register_chatcommand("manhunt_consent", {
				 params = "",
				 description = "Give consent to Runners winning the game.",
				 func = function(name)
				    local arena = arena_lib.get_arena_by_player (name)
				    local already_consenting = 				 arena.players[name].consent
				    local player_count = #arena_lib.get_players_in_team (arena, 1) + #arena_lib.get_players_in_team (arena, 2)
				    if not already_consenting then
				       arena.players[name].consent = true
				       arena.consent_number = arena.consent_number + 1
				       minetest.chat_send_player(name, "You have consented to Runners winning this match.")
				       arena_lib.send_message_in_arena(arena,
								       "both",
								       name .. " has consented to Runners winning.  Total: " .. tostring(arena.consent_number) .. " of " .. tostring (player_count) .. ".")
				    else
				       
				       arena.consent_number = arena.consent_number - 1
				       arena.players[name].consent = false
				       arena_lib.send_message_in_arena(arena,
								       "both",
								       name .. " does not give consent anymore!")
				    end
				    if arena.consent_number >= player_count then
				       arena_lib.load_celebration ("manhunt", arena, 1)
				    end
	   
end})

ChatCmdBuilder.new("manhunt", function(cmd)

		      cmd:sub("tutorial", function(name)
				 minetest.chat_send_player(name, "See the TUTORIAL.txt file in the mod folder.")
		      end)


		      




		      cmd:sub("create :arena", function(name, arena_name)
				 arena_lib.create_arena(name, "manhunt", arena_name)
		      end)



		      cmd:sub("create :arena :minplayers:int :maxplayers:int", function(name, arena_name, min_players, max_players)
				 arena_lib.create_arena(name, "manhunt", arena_name, min_players, max_players)
		      end)



		      cmd:sub("remove :arena", function(name, arena_name)
				 arena_lib.remove_arena(name, "manhunt", arena_name)
		      end)

		      
		      
		      -- list of the arenas
		      cmd:sub("list", function(name)
				 arena_lib.print_arenas(name, "manhunt")
		      end)



		      cmd:sub("info :arena", function(name, arena_name)
				 arena_lib.print_arena_info(name, "manhunt", arena_name)
		      end)



		      -- This sets the spawns using the player position.
		      cmd:sub("setspawn :arena", function(name, arena)
				 arena_lib.set_spawner(name, "manhunt", arena)
		      end)



		      -- This sets the arena sign.
		      cmd:sub("setsign :arena", function(sender, arena)
				 arena_lib.set_sign(sender, nil, nil, "manhunt", arena)
		      end)


		      
		      cmd:sub("edit :arena", function(sender, arena)
				 arena_lib.enter_editor(sender, "manhunt", arena)
		      end)



		      cmd:sub("enable :arena", function(name, arena)
				 arena_lib.enable_arena(name, "manhunt", arena)
		      end)



		      cmd:sub("disable :arena", function(name, arena)
				 arena_lib.disable_arena(name, "manhunt", arena)
		      end)



		      -- Debug commands:
		      cmd:sub("play :sound :gain:number", function(pl_name, sound, gain)
				 minetest.sound_play(sound, { pos = minetest.get_player_by_name(pl_name):get_pos(), gain = gain})
		      end)

end, {
		      description = [[
     
    ADMIN COMMANDS
    (Use /help manhunt to read it all)

    Use this to configure your arena:
    - tutorial
    - create <arena name> [min players] [max players]
    - edit <arena name> 
    - enable <arena name>
    
    Other commands:
    - list
    - info <arena name>
    - remove <arena name>
    - disable <arena name>
    - logs <arena name>
    ]],
    privs = { manhunt_admin = true }
})
