-- Copyright 2023  marsuh228

-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at

--     http://www.apache.org/licenses/LICENSE-2.0

-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- A radar/GPS mod for those who are worn out by the defaultness of
-- the default MTG map mod.  Recipes available for TechAge hackers.
-- Not yet written for defaulters (Coming soon!)

--- Code:

-- A very good and helpful (trust me) procedure that finds an item in
-- the "main" list of a given inventory and returns the item's index.
-- Needed because inv:contains_item(bebebe) only says whether there is
-- an item at all and not where it is exactly.
local function find_item(inv, stack)
   local inv = inv:get_list("main")
   for i, v in ipairs (inv) do
      if stack == v:get_name() then
	 return i
      end
   end
   return nil
end

-- Computes the wear that should be added
-- to the item per 5.3 seconds

-- Basically, '65535' (the wear) is comparable to some path, and
-- 'period' is the time over which the path is crossed.  We need to
-- compute the speed (how much wear is added per 5.3 seconds), and
-- this is rather simple:

-- S / t = v,
-- where S is the distance, t is time and v is velocity.
local function compute_depletion (period)
   return math.floor ((65535 / period) * 5.3)
end

-- The procedure to deplete the charge of a given device.
local function deplete_charge (inv, stack)
   local index = find_item (inv, stack)
   if not index then return end
   local depletion
   local maximum_wear
   local uncharged_item
   if stack == "nomap:gps" then
      local time = 780 -- In seconds
      depletion = compute_depletion (time)
      maximum_wear = 65535 - (depletion + 1)
      uncharged_item = "nomap:gps_uncharged"
   else
      local time = 300 -- In seconds, too
      depletion = compute_depletion (time)
      maximum_wear = 65535 - (depletion + 1)
      uncharged_item = "nomap:radar_uncharged"      
   end
   
   local oldstack = inv:get_stack ("main", index)
   local wear = oldstack:get_wear()
   if wear >= maximum_wear then
      inv:set_stack("main", index, uncharged_item)
   else
      oldstack:add_wear(depletion)
      inv:set_stack("main", index, oldstack)
   end
end


-- Overriden, overthrown!  Now checks whether the radar/GPS is 'on' or
-- not.
map.update_hud_flags = function(player)
   if not player then return end
   local inv = player:get_inventory()
   local radar = "nomap:radar"
   local gps = "nomap:gps"
   local has_radar = inv:contains_item("main", radar)
   local has_minimap = inv:contains_item("main", gps)
   local minimap_enabled
   local radar_enabled
   local visible
   
   if has_radar and has_minimap then
      
      minimap_enabled = true
      radar_enabled = true
      visible = true
      deplete_charge (inv, radar)
      deplete_charge (inv, gps)
   elseif has_radar then

      minimap_enabled = true
      radar_enabled = true
      visible = true
      deplete_charge (inv, radar)
   elseif has_minimap then
   
      minimap_enabled = true
      radar_enabled = false
      visible = true
      deplete_charge (inv, gps)
   else
      minimap_enabled = false
      radar_enabled = false
      visible = false
   end
   local props = player:get_properties()
   props.show_on_minimap = visible
   player:set_properties(props)
   
   player:hud_set_flags({
	 minimap = minimap_enabled,
	 minimap_radar = radar_enabled
   })
end

-- An on_secondary_use procedure for the GPS.x
local function gps_action (itemstack, user, pointed_thing)
   local swap_name = "nomap:gps"
   local wear = itemstack:get_wear()
   if itemstack:get_name() == "nomap:gps" then
      swap_name = "nomap:gps_off"
   end
   itemstack:set_name(swap_name)
   itemstack:set_wear(wear)
   return itemstack
end

-- A separate procedure for the radar.
local function radar_action (itemstack, user, pointed_thing)
   local swap_name = "nomap:radar"
   local wear = itemstack:get_wear()
   if itemstack:get_name() == "nomap:radar" then
      swap_name = "nomap:radar_off"
   end
   itemstack:set_name(swap_name)
   itemstack:set_wear(wear)
   return itemstack
end


-- Ugly.  Some abstraction must be lurking there, but I don't see it
-- yet.
minetest.register_tool("nomap:gps", {
      description = "GPS",
      short_description = "gps",
      inventory_image = "nomap_gps.png",
      stack_max = 1,
      on_secondary_use = gps_action,
      on_place = gps_action})

minetest.register_tool("nomap:gps_off", {
      description = "GPS\nOff",
      short_description = "gps",
      inventory_image = "nomap_gps_off.png",
      stack_max = 1,
      on_secondary_use = gps_action,
      on_place = gps_action})

minetest.register_tool("nomap:gps_uncharged", {
      description = "GPS\nNo Power",
      short_description = "gps",
      inventory_image = "nomap_gps_off.png",
      stack_max = 1})

minetest.register_tool("nomap:radar", {
      description = "Radar",
      short_description = "radar",
      inventory_image = "nomap_radar.png",
      stack_max = 1,
      on_secondary_use = radar_action,
      on_place = radar_action})

minetest.register_tool("nomap:radar_off", {
      description = "Radar\nOff",
      short_description = "radar",
      inventory_image = "nomap_radar_off.png",
      stack_max = 1,
      on_secondary_use = radar_action,
      on_place = radar_action})

minetest.register_tool("nomap:radar_uncharged", {
      description = "Radar\nNo power",
      short_description = "radar",
      inventory_image = "nomap_radar_off.png",
      stack_max = 1})

-- To not let kids get gratis bobux before the time is right.
minetest.clear_craft({output = "map:mapping_kit"})

-- Recipes.
minetest.register_craft({
      output = "nomap:gps_off",
      recipe = {
	 {"default:mese_crystal", "techage:ta4_display", "default:mese_crystal"},
	 {"default:steel_ingot", "techage:ta4_icta_controller", "default:steel_ingot"},
	 {"", "techage:ta4_battery", ""}}})

minetest.register_craft({
      output = "nomap:radar_off",
      recipe = {
	 {"default:diamond", "techage:ta4_display", "default:diamond"},
	 {"default:steel_ingot", "techage:ta4_lua_controller", "default:steel_ingot"},
	 {"", "techage:ta4_battery", ""}}})

-- It's rechargeable!
minetest.register_craft({
      output = "nomap:radar_off",
      type = "shapeless",
      recipe = {"nomap:radar_uncharged", "techage:ta4_battery"}})

minetest.register_craft({
      output = "nomap:gps_off",
      type = "shapeless",
      recipe = {"nomap:gps_uncharged", "techage:ta4_battery"}})

-- Happy hacking.

-- Glory to Republic of Korea.

-- End of program.
