-- NucleoTest Game
-- Copyright (C) 2023  LissoBone

-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- This is a reference implementation.

local initialradius = 1024
local initialwait = 181
local shrinkspeed = 4
local sizeratio = 3/4
local timeratio = 6/7
nucleotest.setradius(initialradius)
local gametest = {}
function gametest.shrink(speed, seconds)
   local radius = nucleotest.getradius()
   if radius <= 7 then
      minetest.chat_send_all("Too dense. Shrinking no further.")
      return
   end
   
   local newradius = radius * sizeratio
   local time = (radius - newradius) / speed
   local center = nucleotest.getcenter()
   local newcenter = nucleotest.randomcircor(center, radius - newradius)
   minetest.chat_send_all("Shrinking! The new center is x: " .. newcenter.x .. ", z: " .. newcenter.z)
   nucleotest.shrinkradius(radius, radius, newradius, time, 0.1, 0)
   nucleotest.shrinkcenter(center.x, center.z, center.x, center.z, newcenter.x, newcenter.z, time, 0.1, 0)
   minetest.after(tonumber(time), gametest.notify, math.ceil(timeratio * seconds))
   return
end

function gametest.notify(seconds)
   minetest.chat_send_all("The map will shrink in " .. seconds .. " seconds!")
   minetest.after(tonumber(seconds), gametest.shrink, shrinkspeed, seconds)
   return
end

minetest.register_chatcommand("nucleotest-start", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 description = "Start the game.",
				 func = function(name, param)
				    
				    if nucleotest.startgame() then
				       minetest.chat_send_all("The game has started. Loot the environment and outsurvive other contestants.")
				       minetest.after(6, gametest.notify, initialwait)
				    else
				       minetest.chat_send_player(name, "Invalid.")
				       return
				    end
end})
