nucleotest = {}
nucleotest.gameprops = {}
nucleotest.gameprops.radius = tonumber(770)
nucleotest.gameprops.center = {}
nucleotest.gameprops.center.x = 0
nucleotest.gameprops.center.z = 0
nucleotest.contestants = {}
nucleotest.raddmg = {}
nucleotest.lock = {}
nucleotest.protection = {}
-- nucleotest.geiger = {}
nucleotest.game = false

function nucleotest.getradius()
   return nucleotest.gameprops.radius
end

function nucleotest.getcenter()
   return nucleotest.gameprops.center
end

function nucleotest.getcontestants()
   return nucleotest.contestants()
end

function nucleotest.getraddmg()
   return nucleotest.raddmg
end

function nucleotest.getgame()
   return nucleotest.game
end
      
function nucleotest.hasValue(tbl, value)
   for k, v in ipairs(tbl) do -- iterate table (for sequential tables only)
      if v == value or (type(v) == "table" and hasValue(v, value)) then
	 return true -- Found in this or nested table
      end
   end
   return false -- Not found
end

function nucleotest.indexOf(array, value)
   for i, v in ipairs(array) do
      if v == value then
	 return i
      end
   end
   return nil
end


function nucleotest.listall()
   -- minetest.log(#nucleotest.contestants)
   if #nucleotest.contestants == 0 then
      -- minetest.chat_send_player(name, "No players participating yet.")
      return false
   end
   
   local result = "Participants: "
   
   for n, i in pairs(nucleotest.contestants) do
      if n ~= #nucleotest.contestants then
	 result = result .. i .. ", "
      else
	 result = result .. i .. "."
      end
   end
   -- minetest.chat_send_player(name, result)
   return result
end

function nucleotest.addall()
   local players = minetest.get_connected_players()
   for _, i in pairs(players) do
      -- minetest.log(i:get_player_name())
      if nucleotest.hasValue(nucleotest.contestants, i:get_player_name()) then
	 goto cont1
      end
      nucleotest.contestants[#nucleotest.contestants + 1] = i:get_player_name()
      ::cont1::
   end
   return true
end

function nucleotest.setcenter(x, z)
   if not tonumber(x) or not tonumber(z) then
      return false
   end
   x = math.floor(tonumber(x))
   z = math.floor(tonumber(z))
   nucleotest.gameprops.center.x = x
   nucleotest.gameprops.center.z = z
   return {x = x, z = z}
end

-- I know that this is an incorrect name, but it's sort of funny (only sort of).
function nucleotest.shrinkcenter(x, z, x1, z1, x2, z2, t, step, iter)
   if iter >= t then
      return true
   end
   
   if not tonumber(x) or not tonumber(z) or not tonumber(x1) or not tonumber(z1) or not tonumber(x2) or not tonumber(z2) then
      return false
   end
   x = x + (x2 - x1) / t * step
   z = z + (z2 - z1) / t * step
   nucleotest.gameprops.center = {x = x, z = z}
   iter = iter + step
   minetest.after(step, nucleotest.shrinkcenter, x, z, x1, z1, x2, z2, t, step, iter)
   return
end

function nucleotest.shrinkradius(l, l1, l2, t, step, iter)
   if iter >= t then
      return true
   end
   
   if not tonumber(l) or not tonumber(l1) or not tonumber(l2) then
      return false
   end
   local l = l + (l2 - l1) / t * step
   nucleotest.gameprops.radius = l
   iter = iter + step
   minetest.after(step, nucleotest.shrinkradius, l, l1, l2, t, step, iter)
   return
end

function nucleotest.startgame()
   if #nucleotest.contestants <= 1 then
      return false
   end
   if nucleotest.game == true then
      return false
   end
   minetest.after(6, function() nucleotest.game = true end)
   local players = minetest.get_connected_players()
   for _, i in pairs(nucleotest.contestants) do
      local player = minetest.get_player_by_name(i)
      if not nucleotest.hasValue(players, player) then
	 goto cont5
      end
      local inv = player:get_inventory()
      if not inv then
	 goto cont4
      end
      if not inv:contains_item("main", ItemStack("nucleotest_api:geigercounter")) then
	 player:get_inventory():add_item("main", ItemStack("nucleotest_api:geigercounter"))
      else
	 goto cont4
      end
      ::cont4::
      nucleotest.spreadplayers(nucleotest.gameprops.radius * 5/6, i)
      ::cont5::
   end
   return true
end

function nucleotest.stopgame(winner)
   if nucleotest.game == false then
      return false
   end
   nucleotest.game = false
end

function nucleotest.removeplayer(name)
   if not nucleotest.hasValue(nucleotest.contestants, name) then
      return false
   end
   table.remove(nucleotest.contestants, nucleotest.indexOf(nucleotest.contestants, name))
   return true
end

function nucleotest.setradius(radius)
   if not tonumber(radius) then
      return false
   end
   nucleotest.gameprops.radius = tonumber(radius)
   return radius
end

function nucleotest.removeall()
   nucleotest.contestants = {}
   return true
end

function nucleotest.addplayer(name)
   if not nucleotest.hasValue(minetest.get_connected_players(), minetest.get_player_by_name(name)) then
      return false
   end
   if nucleotest.hasValue(nucleotest.contestants, name) then
      return false
   end
   
   nucleotest.contestants[#nucleotest.contestants + 1] = param
   return name
end

function nucleotest.randomcircor(center, radius)
   local r = radius * math.sqrt(math.random(1, 1000000)/1000000)
   local th = math.random(1, 1000000)/1000000 * 2 * math.pi
   local x = math.floor(center.x + r * math.cos(th))
   local z = math.floor(center.z + r * math.sin(th))
   local y = 0
   return vector.new(x, y, z)
end

function nucleotest.spreadplayers(maxradius, name)

   local radius = maxradius
   if not tonumber(maxradius) or not maxradius then
      local radius = 5/6 * nucleotest.gameprops.radius
   end
   
   local center = nucleotest.gameprops.center
   if #nucleotest.contestants == 0 then
      return false
   end

   --for _, i in pairs(nucleotest.contestants) do
   local coords = nucleotest.randomcircor(center, radius)
   local player = minetest.get_player_by_name(name)
   local it = 1
   player:setpos(coords)
   minetest.after(3, function(coords, player, it)
		     while minetest.get_node(player:getpos()).name ~= "air" do
			coords.y = coords.y + 1
			player:setpos(coords)
			if coords.y > 500 then
			   coords.y = 0 - 2^it
			   it = it + 1 
			end
			if it >= 5 then
			   coords.z = coords.z - 5
			   coords.x = coords.x - 5
			end
			
			   if minetest.get_node(player:getpos()).name == "air" then
			      return true
			   end
			end
		     end, coords, player, it)
   return true
end

