minetest.register_privilege("nucleotestadmin", {
			       description = "Controls the flow of Test Royale.",
})

minetest.register_chatcommand("nucleotest-setsize", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 params = "<number>",
				 description = "Sets the radius of the battlefield.",
				 func = function(name, param)
				    if not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    if not tonumber(param) or not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    if nucleotest.setradius(tonumber(param)) then
				       minetest.chat_send_player(name, "New radius is " .. param)
				       return
				    end
end})
				 
				 

minetest.register_chatcommand("nucleotest-addplayer", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 params = "<name>",
				 description = "Add a player to participate in the game.",
				 func = function(name, param)
				    if not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    
				    if nucleotest.addplayer(param) then
				       minetest.chat_send_player(name, param .. " Has been added.")
				    else
				       minetest.chat_send_player(name, "Invalid. No such player online.")
				    end
end})

minetest.register_chatcommand("nucleotest-addall", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 description = "Add all players to the game.",
				 func = nucleotest.addall})

minetest.register_chatcommand("nucleotest-setcenter", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 params = "<X> <Z>",
				 description = "Set the center of the battlefield",
				 func = function(name, param)
				    if not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    params = param:split(" ")
				    if not tonumber(params[1]) or not tonumber(params[2]) then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    if nucleotest.setcenter(params[1], params[2]) then
				       minetest.chat_send_player(name, "New center is x: " .. params[1] .. ", z: " .. params[2])
				    end
end})

minetest.register_chatcommand("nucleotest-removeplayer", {
				 privs = {
				    nucleotestadmin = true,
				 },
				 params = "<name>",
				 description = "Condemn a player from participating in the game.",
				 func = function(name, param)
				    if not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    if nucleotest.removeplayer(param) then
				       minetest.chat_send_player(name, param .. " Has been removed.")
				    else
				       minetest.chat_send_player(name, "Invalid.")
				    end
end})

minetest.register_chatcommand("nucleotest-listplayers", {
				 privs = {
				 },
				 description = "List participants.",
				 func = function(name, params)
				    local result = nucleotest.listall()
				    if result then
				       minetest.chat_send_player(name, result)
				       return
				    else
				       minetest.chat_send_player(name, "Invalid.")
				       return
				    end
end})

-- minetest.register_abm({
--       nodenames = {"default:dirt_with_grass", "default:sand", "default:stone"},
--       interval = 2.0,
--       chance = 2,
--       action = function(pos, node, active_object_count, active_object_count_wider)
-- 	 if nucleotest.game == false then
-- 	    return
-- 	 end
-- 	 if ((pos.x - nucleotest.gameprops.center.x)^2 + (pos.z - nucleotest.gameprops.center.z)^2) >= nucleotest.gameprops.radius^2 then
-- 	    return
-- 	 end
	 
-- 	 local npos = {x = pos.x, y = pos.y + 1, z = pos.z}
-- 	 minetest.set_node(npos, {name = "default:chest"})
-- 	 local inv = minetest.get_inventory({type = "node", pos = npos})
-- 	 local size = math.random(4, 8)
-- 	 inv:set_size("main", size)
-- end})




minetest.register_chatcommand("nucleotest-spreadplayers", {
				 privs = {nucleotestadmin = true,
				 },
				 description = "Spread the players across the map. Designed for testing purposes only, as the process is usually automatic when starting the game.",
				 func = function(name, param)
				    local maxradius = 5/6 * nucleotest.gameprops.radius
				    for _, i in pairs(nucleotest.contestants) do
				       nucleotest.spreadplayers(maxradius, i)
				    end
end})

minetest.register_chatcommand("nucleotest-shrinkradius", {
				 privs = {nucleotestadmin = true,
				 },
				 params = "<new length> <time> <step>",
				 description = "Smoothly change the radius. Designed for testing purposes.",
				 func = function(name, param)
				    if not param then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    params = param:split(" ")
				    if #params ~= 3 then
				       minetest.chat_send_player(name, "Invalid argument.")
				       return
				    end
				    
				    minetest.after(tonumber(params[3]), nucleotest.shrinkradius, nucleotest.gameprops.radius, nucleotest.gameprops.radius, tonumber(params[1]), tonumber(params[2]), tonumber(params[3]), 0)
				    return
end})
				 
--[[
minetest.register_on_joinplayer(function(player, last_login)
      if not nucleotest.geiger[player:get_player_name()] then
	 nucleotest.geiger[player:get_player_name()] = false
      end
end)
]]

minetest.register_globalstep(function(dtime)
      if nucleotest.game == false then
	 return
      end
      for _, i in pairs(nucleotest.contestants) do
	 local player = minetest.get_player_by_name(i)
	 if not player then
	    return
	 end
	 if not nucleotest.raddmg[i] then
	    nucleotest.raddmg[i] = 0
	 end
	 local ppos = player:get_pos()
	 local dist = math.sqrt(math.abs(nucleotest.gameprops.center.x - ppos.x)^2 + math.abs(nucleotest.gameprops.center.z - ppos.z)^2)
	 local effect = (1.1 ^ (dist - nucleotest.gameprops.radius) + 0.01)

	 if not player:get_inventory():contains_item("main", ItemStack("nucleotest_api:geigercounter")) then
	    goto dmg
	 end
		 
	 if math.random(0, 1/effect) <= 1 then
	    minetest.sound_play("geiger", {to_player = i})
	 end
	 ::dmg::

	 nucleotest.raddmg[i] = (999/1000)*nucleotest.raddmg[i] + effect^0.76 - 2
	 if nucleotest.raddmg[i] < 0 then nucleotest.raddmg[i] = 0 end
	 if nucleotest.raddmg[i] >= 750 then
	    if nucleotest.lock[i] == true then
	       goto lock
	    end
	    nucleotest.lock[i] = true
	    minetest.after(34/math.sqrt(nucleotest.raddmg[i]), function() nucleotest.lock[i] = false end)
	    player:set_hp(player:get_hp() - 1, {type = "set_hp"})
	 end
	 -- minetest.log(nucleotest.raddmg[i] .. ", " .. effect)
	 ::lock::
      end
end)

minetest.register_on_dieplayer(function(player, reason)
      local name = player:get_player_name()
      if not nucleotest.hasValue(nucleotest.contestants, name) then
	 return
      end
      -- TODO: do something else with the losing players.
      -- Maybe add an extra table for them.
      table.remove(nucleotest.contestants, nucleotest.indexOf(nucleotest.contestants, name))
      if #nucleotest.contestants <= 1 then
	 nucleotest.game = false
	 minetest.chat_send_all("The game has finished. The last standing player is " .. nucleotest.contestants[1] .. ".")
      end
      
      return
end)

