--[[
   Thruster - a device used to propel objects in space.
   Copyright (C) 2022  Neli Kinestesy

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.
]]

thruster = {}
thruster.lock = {}

local lock_enable = tonumber(minetest.settings:get("enable_thrust_pause")) or true
-- minetest.log(tostring(lock_enable))
local function unlock(player_name)
   thruster.lock[player_name] = false
   return
end

local function mkparticle(player, veloc, counter, ender)
   local ppos = player:get_pos()
   ppos.y = ppos.y + 0.7
   local dir = player:get_look_dir()
   local vel = player:get_velocity()
   minetest.add_particle({
	 pos = ppos,
	 velocity = {x = veloc*dir.x + vel.x + math.random(-30, 30)/10, y = math.random(-30, 30)/10 + veloc*dir.y + vel.y, z = veloc*dir.z + vel.z + math.random(-30, 30)/10},
	 size = veloc*0.267 + math.random(-10, 10)/20,
	 expirationtime = 3 + math.random(-10, 10)/10,
	 collisiondetection = true,
	 texture = "thruster_particle" .. math.random(1, 2) .. ".png",
	 bounce = {min = 0.005, max = 0.06}
   })
   if counter < ender then
      counter = counter + 1
   elseif counter >= ender then
      return
   end
   minetest.after(0.013, mkparticle, player, veloc, counter, ender)
end


local function thrust(itemstack, player, pointed_thing)

   if itemstack:get_wear() >= 64512 then
      itemstack:set_name("thruster:thruster_empty")
      return itemstack
   end
   local player_name = player:get_player_name()
   if lock_enable == true then
--      minetest.log("1")
      if thruster.lock[player_name] == true then
--	 minetest.log("2")
	 return
      end
      thruster.lock[player_name] = true
      minetest.after(0.3695, unlock, player_name)
   end
   local dir = player:get_look_dir()

   minetest.after(0.08, mkparticle, player, 49.5, 1, 21)
   
   minetest.sound_play("thruster_thrust", {object = player, max_hear_distance = 50})
   player:add_velocity({x = -6 * dir.x, y = -6 * dir.y, z = -6 * dir.z})
   itemstack:add_wear(768)
   return itemstack
end

local function smallthrust(itemstack, player, pointed_thing)
   if itemstack:get_wear() >= 64512 then
      itemstack:set_name("thruster:thruster_empty")
      return itemstack
   end
   
   if lock_enable == true then
      local player_name = player:get_player_name()
      if thruster.lock[player_name] == true then
	 return
      end
      minetest.after(0.12318, unlock, player_name)
      thruster.lock[player_name] = true
   end
   
   local pos = player:get_pos()
   local dir = player:get_look_dir()
   minetest.sound_play("thruster_thrust_small", {object = player, max_hear_distance = 50})
   player:add_velocity({x = -2 * dir.x, y = -2 * dir.y, z = -2 * dir.z})
   itemstack:add_wear(256)
   minetest.after(0.08, mkparticle, player, 38.25, 1, 21)
   return itemstack
end

minetest.register_craftitem("thruster:propellant", {
			       description = "Propellant tank",
			       inventory_image = "thruster_propellant.png",
			       stack_max = 1,
})

minetest.register_craftitem("thruster:propellant_empty", {
			       description = "Empty propellant tank",
			       inventory_image = "thruster_propellant_empty.png",
			       stack_max = 1,
})

minetest.register_tool("thruster:thruster", {
			  description = "Thruster",
			  inventory_image = "thruster_inv.png",
			  wield_image = "thruster_wield.png",
			  stack_max = 1,
			  tool_capabilities = {
			     full_punch_interval = 0.5,
			     max_drop_level = 0,
			     groupcaps = {
				fleshy = {times = 0, max_uses = 300}
			     },
			  },
			  on_use = thrust,
			  on_secondary_use = smallthrust,
			  on_place = smallthrust,
})

minetest.register_craftitem("thruster:thruster_empty", {
			       description = "Empty thruster",
			       inventory_image = "thruster_inv_empty.png",
			       wield_image = "thruster_wield_empty.png",
			       stack_max = 1,
			       on_use = function(itemstack, player)
				  minetest.sound_play("thruster_error", {object = player}) end,
			       on_secondary_use = function(itemstack, player)
				  local stack = ItemStack("thruster:propellant_empty")
				  local inv = player:get_inventory()
				  if inv:room_for_item("main", stack) then
				     i = inv:add_item("main", stack)
				     minetest.sound_play("thruster_unload", {object = player})
				     itemstack:set_name("thruster:thruster_unloaded")
				  end
				  return itemstack
			       end,
			       on_place = function(itemstack, player)
				  local stack = ItemStack("thruster:propellant_empty")
				  local inv = player:get_inventory()
				  if inv:room_for_item("main", stack) then
				     i = inv:add_item("main", stack)
				     minetest.sound_play("thruster_unload", {object = player})
				     itemstack:set_name("thruster:thruster_unloaded")
				  end
				  return itemstack
			       end
})
			       
minetest.register_craftitem("thruster:thruster_unloaded", {
			       description = "Unloaded thruster",
			       inventory_image = "thruster_inv_unloaded.png",
			       wield_image = "thruster_wield_unloaded.png",
			       stack_max = 1,
			      
			       on_secondary_use = function(itemstack, player)
				  local inv = player:get_inventory()
				  local n = 0
				  for _, i in pairs(inv:get_list("main")) do
				     if i:get_name() == "thruster:propellant" then
					local wear = i:get_wear()
					inv:remove_item("main", i)
					n = 1
					minetest.sound_play("thruster_load", {object = player})
					itemstack:set_name("thruster:thruster")
					itemstack:set_wear(wear)
					break
				     end
				  end
				  if n == 0 then
				     minetest.sound_play("thruster_error", {object = player})
				  end
				  return itemstack
			       end,
			       on_place = function(itemstack, player)
				  local inv = player:get_inventory()
				  local n = 0
				  for _, i in pairs(inv:get_list("main")) do
				     if i:get_name() == "thruster:propellant" then
					local wear = i:get_wear()
					inv:remove_item("main", i)
					n = 1
					minetest.sound_play("thruster_load", {object = player})
					itemstack:set_name("thruster:thruster")
					itemstack:set_wear(wear)
					break
				     end
				  end
				  if n == 0 then
				     minetest.sound_play("thruster_error", {object = player})
				  end
				  return itemstack
end})
				  

minetest.register_craft({
      output = "thruster:propellant",
      recipe = {
	 {"default:coal_lump", "default:mese_crystal", "default:coal_lump"},
	 {"default:steel_ingot", "vessels:steel_bottle", "default:steel_ingot"},
	 {"", "default:steel_ingot", ""},
      }
})
minetest.register_craft({
      type = "shapeless",
      output = "thruster:propellant",
      recipe = {
	 "default:coal_lump",
	 "default:coal_lump",
	 "default:mese_crystal",
	 "thruster:propellant_empty",
      },
})

minetest.register_craft({
      output = "thruster:propellant_empty",
      recipe = {
	 {"", "", ""},
	 {"default:steel_ingot", "vessels:steel_bottle", "default:steel_ingot"},
	 {"", "default:steel_ingot", ""},
      }
})

minetest.register_craft({
      output = "thruster:thruster_unloaded",
      recipe = {
	 {"default:steel_ingot", "", "default:steel_ingot"},
	 {"default:copper_ingot", "default:mese", "default:copper_ingot"},
	 {"default:mese_crystal", "default:steel_ingot", "default:mese_crystal"},
      }
})
