-- Roulette Table Mod
-- Author: Liyah Mackenzie Hernandez
-- License: MIT

local S = minetest.get_translator("roulette")

-- Helper to generate random number 0-31
local function spin_roulette()
    return math.random(0, 31)
end

-- Handle GUI and betting logic
local function get_roulette_formspec()
    return table.concat({
        "formspec_version[4]",
        "size[10,8]",
        "bgcolor[#2b2b2b;true]",

        -- Title bar
        "box[0,0;10,1;#3c3c3c]",
        "label[0.3,0.3;Roulette Table]",
        "style_type[label;font=mono;color=white]",

        -- Wager section
        "box[0.2,1.2;3.5,2;#3a3a3a]",
        "label[0.3,1.3;Item Wager:]",
        "list[current_player;craft;1,1.7;1,1;]",

        -- Betting options section
        "box[3.8,1.2;5.8,2;#3a3a3a]",
        "label[3.9,1.3;Type:]",
        "dropdown[4.2,1.8;2;bet_type;Odd,Even,Num;1]",
        "label[6.5,1.3;Num(0–31):]",
        "field[6.5,1.7;1.2,1;bet_number;;]",

        -- Spin button
        "button[4.2,3.5;2,1;spin;Spin]",

        -- Player inventory
        "list[current_player;main;1,4.5;8,4;]"
    })
end

-- Form handling
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "roulette:table_gui" then return false end

    if fields.spin then
        local inv = player:get_inventory()
        local stack = inv:get_stack("craft", 1) -- wager slot
        if stack:is_empty() then
            minetest.chat_send_player(player:get_player_name(), "You must place an item to wager.")
            return true
        end

        local wager_item = stack:get_name()
        local wager_count = stack:get_count()
        local spin_result = spin_roulette()
        local won = false
        local multiplier = 0

        if fields.bet_type == "Odd" and spin_result % 2 == 1 then
            won = true
            multiplier = 2
        elseif fields.bet_type == "Even" and spin_result % 2 == 0 then
            won = true
            multiplier = 2
        elseif fields.bet_type == "Num" then
            local bet_num = tonumber(fields.bet_number)
            if bet_num and bet_num == spin_result then
                won = true
                multiplier = 10
            end
        end

        minetest.chat_send_player(player:get_player_name(),
            "Roulette spun and landed on " .. spin_result .. "!")

        if won then
            local payout = ItemStack(wager_item .. " " .. (wager_count * multiplier))
            inv:add_item("main", payout)
            inv:set_stack("craft", 1, nil)
            minetest.chat_send_player(player:get_player_name(),
                "You won! Your payout is in your inventory.")
        else
            inv:set_stack("craft", 1, nil)
            minetest.chat_send_player(player:get_player_name(), "You lost your wager.")
        end

        -- Refresh GUI so fields reset
        minetest.show_formspec(player:get_player_name(), "roulette:table_gui", get_roulette_formspec())
        return true
    end
end)


-- Node registration
minetest.register_node("roulette:roulette_table", {
    description = "Roulette Table",
    drawtype = "nodebox",
    tiles = {
        "roulette_table_top.png",  -- top
        "default_wood.png",        -- bottom
        "default_wood.png",        -- right
        "default_wood.png",        -- left
        "default_wood.png",        -- back
        "default_wood.png"         -- front
    },
    paramtype = "light",
    node_box = {
        type = "fixed",
        fixed = {
            -- tabletop (1 × 1 × 0.1, sits on top of legs)
            {-0.5, 0.0, -0.5, 0.5, 0.1, 0.5},

            -- legs (height = 0.5, starting at ground y=-0.5)
            {-0.45, -0.5, -0.45, -0.35, 0.0, -0.35},
            { 0.35, -0.5, -0.45,  0.45, 0.0, -0.35},
            {-0.45, -0.5,  0.35, -0.35, 0.0,  0.45},
            { 0.35, -0.5,  0.35,  0.45, 0.0,  0.45},
        }
    },
    selection_box = {
        type = "fixed",
        fixed = {-0.5, -0.5, -0.5, 0.5, 0.1, 0.5}
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.5, -0.5, -0.5, 0.5, 0.1, 0.5}
    },
    groups = {choppy = 2, oddly_breakable_by_hand = 2, furniture = 1},
    sounds = default.node_sound_wood_defaults(),

    -- Add this callback
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
        minetest.show_formspec(player:get_player_name(),
            "roulette:table_gui",
            get_roulette_formspec()
        )
    end,
})


-- Craft recipe
minetest.register_craft({
    output = "roulette:roulette_table",
    recipe = {
        {"default:iron_ingot", "default:gold_ingot", "default:wood"},
        {"default:iron_ingot", "default:gold_ingot", "default:wood"},
        {"default:iron_ingot", "default:gold_ingot", "default:wood"},
    },
})
