dungeons = {
    registered_dungeons = {},
    dungeon_start_pos = vector.new(0, vkore.settings.world_size/2, 0)
}

local dpath = minetest.get_modpath("dungeons") .. "/dungeons/"

function dungeons.register_dungeon(name, def)
    dungeons.registered_dungeons[name] = def

    local registered_levels = minetest.get_dir_list(dpath .. name .. "/levels/", "false")
    dungeons.registered_dungeons[name].levels = {}

    for _, level in pairs(registered_levels) do
        if level:find(".mts") then
            table.insert(dungeons.registered_dungeons[name].levels, dpath .. name .. "/levels/" .. level)
        else
            minetest.log("error", "Failed to register level " .. dump(level) .." for dungeon " .. dump(name))
        end
    end
end

function dungeons.start_dungeon(pos, dungeon_name)
    minetest.place_schematic(dungeon_start_pos, get_random_dungeon(), random, nil, true)
    minetest.read_schematic("my_schematic.mts").size
    -- spawn a schematic at the dungeon startpos
    -- find the start node
    -- Send the starting pos to party members
    -- teleport party members within 1.5? nodes of pos there
end
