print("This file will be run at load time!")
local S = minetest.get_translator("super_foods")

minetest.register_craftitem("super_foods:cake", {
	description = S("Slice Of Cake"),
	inventory_image = "SFcake_slice.png",
	on_use = minetest.item_eat(6),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:apple_pie_slice", {
	description = S("Apple Pie Slice"),
	inventory_image = "SFapple_pie_slice.png",
	on_use = minetest.item_eat(6),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:blueberry_pie_slice", {
	description = S("Blueberry Pie Slice"),
	inventory_image = "SFblueberry_pie_slice.png",
	on_use = minetest.item_eat(6),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:apple_pie_a_la_mode", {
	description = S("Apple Pie à la Mode"),
	inventory_image = "SFapple_a_la_mode.png",
	on_use = minetest.item_eat(12),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:blueberry_pie_a_la_mode", {
	description = S("Blueberry Pie à la Mode"),
	inventory_image = "SFblueberry_a_la_mode.png",
	on_use = minetest.item_eat(12),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:ice_cream", {
	description = S("Ice Cream"),
	inventory_image = "SFice_cream.png",
	on_use = minetest.item_eat(6, "super_foods:coconut_bowl"),
	groups = {food = 2},
})

minetest.register_craftitem("super_foods:cheese", {
	description = S("Wedge Of Cheese"),
	inventory_image = "SFcheese_slice.png",
	on_use = minetest.item_eat(5),
	groups = {food = 4},
})

minetest.register_craftitem("super_foods:watermelon_slice", {
	description = S("Slice Of Watermelon"),
	inventory_image = "SFwatermelon_slice.png",
	on_use = minetest.item_eat(4),
	groups = {food = 4},
})

minetest.register_craftitem("super_foods:sugar", {
	description = S("Sugar"),
	inventory_image = "SFsugar.png",
	groups = {food = 4},
})

minetest.register_craftitem("super_foods:coconut_bowl", {
	description = S("Coconut Bowl"),
	inventory_image = "SFcoconut_bowl.png",
	groups = {items = 1},
})

minetest.register_craftitem("super_foods:coconut_milk", {
	groups = {food = 4},
	description = S("Coconut Milk"),
	inventory_image = "SFcoconut_milk.png",
	on_use = minetest.item_eat(2, "super_foods:coconut_bowl") 
}) 

minetest.register_craftitem("super_foods:mac_and_cheese", {
	groups = {food = 4},
	description = S("Mac & Cheese"),
	inventory_image = "SFmac_and_cheese.png",
	on_use = minetest.item_eat(6, "super_foods:coconut_bowl"),
})

minetest.register_craftitem("super_foods:mushroom_stew", {
	groups = {food = 4},
	description = S("Mushroom Stew"),
	inventory_image = "SFmushroom_stew.png",
	on_use = minetest.item_eat(5, "super_foods:coconut_bowl")
}) 

minetest.register_craftitem("super_foods:berry_ice_pop", {
	groups = {food = 4},
	description = S("Berry Ice Pop"),
	inventory_image = "SFberry_ice_pop.png",
	on_use = minetest.item_eat(4, "default:stick")
})

minetest.register_craftitem("super_foods:apple_ice_pop", {
	groups = {food = 4},
	description = S("Apple Ice Pop"),
	inventory_image = "SFapple_ice_pop.png",
	on_use = minetest.item_eat(4, "default:stick")
})

minetest.register_craftitem("super_foods:watermelon_ice_pop", {
	groups = {food = 4},
	description = S("Watermelon Ice Pop"),
	inventory_image = "SFwatermelon_ice_pop.png",
	on_use = minetest.item_eat(4, "default:stick")
})

minetest.register_craftitem("super_foods:coconut_ice_pop", {
	groups = {food = 4},
	description = S("Coconut Ice Pop"),
	inventory_image = "SFcoconut_ice_pop.png",
	on_use = minetest.item_eat(4, "default:stick")
})

minetest.register_craftitem("super_foods:fruit_salad", {
	groups = {food = 4},
	description = S("Fruit Salad"),
	inventory_image = "SFfruit_salad.png",
	on_use = minetest.item_eat(6, "super_foods:coconut_bowl")
})

minetest.register_craftitem("super_foods:doughnut", {
	groups = {food = 4},
	description = S("Powdered Doughnut"),
	inventory_image = "SFdoughnut.png",
	on_use = minetest.item_eat(7)
})

minetest.register_craftitem("super_foods:muffin", {
	groups = {food = 4},
	description = S("Blueberry Muffin"),
	inventory_image = "SFmuffin.png",
	on_use = minetest.item_eat(6)
})

minetest.register_craftitem("super_foods:apple_juice", {
	groups = {drinks = 1},
	description = S("Apple Juice"),
	inventory_image = "SFapple_juice.png",
	on_use = minetest.item_eat(3, "vessels:drinking_glass")
})

minetest.register_craftitem("super_foods:poisoned_apple_juice", {
	groups = {drinks = 4},
	description = S("Poisoned Apple Juice\nCreative Only"),
	inventory_image = "SFapple_juice.png",
	on_use = minetest.item_eat(-15, "vessels:drinking_glass")

})

minetest.register_node("super_foods:cake_block", {
    description = S("Cake Block"),
    tiles = {   "cake_top.png",	
		"cake_bottom.png",
		"cake_side.png",	-- right
		"cake_side.png",	-- left
		"cake_side.png",	-- back
		"cake_side.png"},	-- front
    is_ground_content = false,
    on_use = minetest.item_eat(20),
    groups = {oddly_breakable_by_hand=3, food=1} ,   
})

minetest.register_node("super_foods:cheese_block", { 
	description = S("Cheese Block"),
	tiles = {"SFcheese_block.png"},
	is_ground_content = false,
	on_use = minetest.item_eat(20),
	groups = {snappy=3, food=2},
})

minetest.register_node("super_foods:watermelon", { 
	description = S("Watermelon"),
	tiles = {"SFwatermelon_top.png",
		 "SFwatermelon_bottom.png",
		 "SFwatermelon_side.png",
		 "SFwatermelon_side.png",
		 "SFwatermelon_side.png",
		 "SFwatermelon_side.png"},
	is_ground_content = false,
	drop = "super_foods:watermelon_slice 9",
	groups = {snappy=3, food=2},
})

minetest.register_node("super_foods:coconut", {
    drawtype = "nodebox",
    node_box = {
        type = "fixed",
        fixed = {-0.25, -0.5, -0.25, 0.25, 0, 0.25}
    },
    description = S("Coconut"),
    is_ground_content = false,
    inventory_image = "SFcoconut.png",
    tiles = {"SFcoconut_side.png",
		"SFcoconut_eyes.png",
		"SFcoconut_side.png",
		"SFcoconut_side.png",
		"SFcoconut_side.png",
		"SFcoconut_side.png" },
    groups = {snappy=3},
})

minetest.register_node("super_foods:dreadfruit", {
    drawtype = "nodebox",
    node_box = {
        type = "fixed",
        fixed = {{-0.375, -0.5, -0.375, 0.375, 0.25, 0.375},
		{-0.125, 0.25, -0.125, 0.125, 0.5, 0.125},},
    },
    description = S("Dreadfruit\nCreative Only"),
    is_ground_content = false,
    inventory_image = "SFdreadfruit.png",
    tiles = {"SFdreadfruit_top.png",
		"SFdreadfruit_bottom.png",
		"SFdreadfruit_side.png",
		"SFdreadfruit_side.png",
		"SFdreadfruit_side.png",
		"SFdreadfruit_front.png" },
    on_use = minetest.item_eat(-20),
    groups = {snappy=3},
})

minetest.register_node("super_foods:apple_pie", {
    drawtype = "nodebox",
    node_box = {
        type = "fixed",
        fixed = {{-0.4375, -0.5, -0.4375, 0.4375, -0.0625, 0.4375},
		{-0.5, -0.1875, -0.5, 0.5, 0.0, 0.5},},
    },
    description = S("Apple Pie"),
    is_ground_content = false,
    tiles = {"SFapple_pie_top.png",
		"SFpie_bottom.png",
		"SFpie_side.png",
		"SFpie_side.png",
		"SFpie_side.png",
		"SFpie_side.png" },
    on_use = minetest.item_eat(20),
    groups = {snappy=3},
})

minetest.register_node("super_foods:blueberry_pie", {
    drawtype = "nodebox",
    node_box = {
        type = "fixed",
        fixed = {{-0.4375, -0.5, -0.4375, 0.4375, -0.0625, 0.4375},
		{-0.5, -0.1875, -0.5, 0.5, 0.0, 0.5},},
    },
    description = S("Blueberry Pie"),
    is_ground_content = false,
    tiles = {"SFblueberry_pie_top.png",
		"SFpie_bottom.png",
		"SFpie_side.png",
		"SFpie_side.png",
		"SFpie_side.png",
		"SFpie_side.png" },
    on_use = minetest.item_eat(20),
    groups = {snappy=3},
})

minetest.register_node("super_foods:sugarcane", {
    drawtype = "plantlike",
    description = S("Sugarcane"),
    inventory_image = "SFsugarcane.png",

    -- Only one texture used
    tiles = {"SFsugarcane.png"},

    selection_box = {
        type = "fixed",
        fixed = {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16},
    },
    groups = {oddly_breakable_by_hand=1, dig_immediate=2},
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.001,
    biomes = {"Beach"},
    y_max = 200,
    y_min = 1,
    decoration = "super_foods:sugarcane",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"super_foods:sugarcane"},
    sidelen = 16,
    fill_ratio = 0.001,
    biomes = {"Beach"},
    y_max = 200,
    y_min = 1,
    decoration = "super_foods:sugarcane",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.0005,
    biomes = {"Beach"},
    y_max = 200,
    y_min = 1,
    decoration = "super_foods:coconut",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    fill_ratio = 0.0001,
    biomes = {"Grass"},
    y_max = 200,
    y_min = 1,
    decoration = "super_foods:watermelon",
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:cake_block",
    recipe = {  "super_foods:cake", "super_foods:cake", "super_foods:cake",
		"super_foods:cake", "super_foods:cake", "super_foods:cake",
		"super_foods:cake", "super_foods:cake", "super_foods:cake" },
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:cheese_block",
    recipe = {  "super_foods:cheese", "super_foods:cheese", "super_foods:cheese",
		"super_foods:cheese", "super_foods:cheese", "super_foods:cheese",
		"super_foods:cheese", "super_foods:cheese", "super_foods:cheese" },
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:cake",
    recipe = {"farming:flour","super_foods:coconut_milk","super_foods:sugar","super_foods:cheese"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:sugar 2",
    recipe = {"super_foods:sugarcane"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:cheese",
    recipe = {"super_foods:coconut_milk"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:coconut_milk",
    recipe = {"super_foods:coconut"},
})

minetest.register_craft({ 
    type ="shapeless",
    output = "super_foods:watermelon",
    recipe = {"super_foods:watermelon_slice", "super_foods:watermelon_slice", "super_foods:watermelon_slice",
              "super_foods:watermelon_slice", "super_foods:watermelon_slice", "super_foods:watermelon_slice",
              "super_foods:watermelon_slice", "super_foods:watermelon_slice", "super_foods:watermelon_slice"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:mac_and_cheese",
    recipe = {"farming:flour", "super_foods:cheese", "super_foods:coconut_bowl", "bucket:bucket_water"},
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:mac_and_cheese",
	recipe = {"farming:flour", "super_foods:cheese", "super_foods:coconut_milk"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:mushroom_stew",
    recipe = {"flowers:mushroom_brown", "flowers:mushroom_red", "super_foods:coconut_milk"},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:berry_ice_pop",
    recipe = {{"", "super_foods:sugar",""},{"default:blueberries","default:ice",""},{"","default:stick",""}},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:apple_ice_pop",
    recipe = {{"", "super_foods:sugar",""},{"default:apple","default:ice",""},{"","default:stick",""}},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:apple_ice_pop",
    recipe = {{"", "super_foods:sugar",""},{"super_foods:apple_juice","default:ice",""},{"","default:stick",""}},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:watermelon_ice_pop",
    recipe = {{"", "super_foods:sugar",""},{"super_foods:watermelon_slice","default:ice",""},{"","default:stick",""}},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:coconut_ice_pop",
    recipe = {{"", "super_foods:sugar",""},{"super_foods:coconut_milk","default:ice",""},{"","default:stick",""}},
})

minetest.register_craft({
    type = "shaped",
    output = "super_foods:fruit_salad",
    recipe = {{"default:apple", "default:blueberries","super_foods:watermelon_slice"},{"","super_foods:coconut_bowl",""},{"","",""}},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:doughnut",
    recipe = {"super_foods:sugar", "super_foods:sugar", "super_foods:sugar", "farming:bread"},
})

minetest.register_craft({
    type = "shapeless",
    output = "super_foods:muffin",
    recipe = {"super_foods:sugar", "farming:flour", "default:blueberries", "super_foods:coconut_milk"},
})

minetest.register_craft({
	type = "shaped",
	output = "super_foods:apple_juice",
	recipe = {{"", "default:apple", ""},{"", "default:apple", ""},{"", "vessels:drinking_glass", ""}},
})

minetest.register_craft({
	type = "shaped",
	output = "super_foods:poisoned_apple_juice",
	recipe = {{"", "super_foods:dreadfruit", ""},{"", "default:apple", ""},{"", "vessels:drinking_glass", ""}},
})

minetest.register_craft({
	type = "shaped",
	output = "super_foods:poisoned_apple_juice",
	recipe = {{"", "", ""},{"", "super_foods:dreadfruit", ""},{"", "super_foods:apple_juice", ""}},
})

minetest.register_craft({
	type = "shaped",
	output = "super_foods:ice_cream",
	recipe = {{"", "super_foods:sugar", ""},{"", "default:ice", ""},{"", "super_foods:coconut_milk", ""}},
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:apple_pie_slice",
	recipe = {"super_foods:sugar", "default:apple", "farming:flour", "super_foods:coconut_milk"}
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:blueberry_pie_slice",
	recipe = {"super_foods:sugar", "default:blueberries", "farming:flour", "super_foods:coconut_milk"}
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:apple_pie_a_la_mode",
	recipe = {"super_foods:apple_pie_slice", "super_foods:ice_cream"}
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:blueberry_pie_a_la_mode",
	recipe = {"super_foods:blueberry_pie_slice", "super_foods:ice_cream"}
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:apple_pie",
	recipe = {"super_foods:apple_pie_slice", "super_foods:apple_pie_slice", "super_foods:apple_pie_slice", 
		"super_foods:apple_pie_slice", "super_foods:apple_pie_slice", "super_foods:apple_pie_slice", 
		"super_foods:apple_pie_slice", "super_foods:apple_pie_slice", "super_foods:apple_pie_slice"}
})

minetest.register_craft({
	type = "shapeless",
	output = "super_foods:blueberry_pie",
	recipe = {"super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice", 
		"super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice", 
		"super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice", "super_foods:blueberry_pie_slice"}
})