-- Tools
minetest.register_tool("classic_mese_stuff:sword_mese", {
    description = "Mese Sword",
    inventory_image = "classic_mese_stuff_sword.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps = {
            snappy = {times = {[1]=0.60, [2]=0.70, [3]=0.30}, uses = 1015, maxlevel = 2},
        },
        damage_groups = {fleshy = 8},
    },
    sound = {breaks = "default_tool_breaks.1"},
    groups = {sword = 1},
})
local base_shovel = minetest.registered_tools["default:shovel_steel"]
local mese_shovel_capabilities = table.copy(base_shovel.tool_capabilities)
for group, caps in pairs(mese_shovel_capabilities.groupcaps) do
    caps.uses = 1015
    for level, time in pairs(caps.times) do
        caps.times[level] = time * 0.6  -- 40% faster
    end
end
minetest.register_tool("classic_mese_stuff:shovel_mese", {
    description = "Mese Shovel",
    inventory_image = "classic_mese_stuff_shovel.png",
    tool_capabilities = mese_shovel_capabilities,
    groups = {shovel = 1},
})

local base_axe = minetest.registered_tools["default:axe_steel"]
local mese_axe_capabilities = table.copy(base_axe.tool_capabilities)
for group, caps in pairs(mese_axe_capabilities.groupcaps) do
    caps.uses = 1015
    for level, time in pairs(caps.times) do
        caps.times[level] = time * 0.6
    end
end
minetest.register_tool("classic_mese_stuff:axe_mese", {
    description = "Mese Axe",
    inventory_image = "classic_mese_stuff_axe.png",
    tool_capabilities = mese_axe_capabilities,
    groups = {axe = 1},
})

-- Nodes
minetest.register_node("classic_mese_stuff:mese_cobble", {
    description = "Mese Cobble",
    tiles = {"classic_mese_stuff_cobble.png"},
    is_ground_content = false,
    groups = {stone = 1},
    sound = {breaks = "default_dig_cracky"},
})
minetest.register_node("classic_mese_stuff:mese_glass", {
    description = "Mese Glass",
    drawtype = "glasslike",
    tiles = {"classic_mese_stuff_glass.png"},
    paramtype = "light",
    sunlight_propagates = true,
    use_texture_alpha = "blend",
    groups = {dig_immediate = 2},
    sound = {breaks = "default_break_glass.1"},
})
minetest.register_node("classic_mese_stuff:ladder_mese", {
	description = ("Mese Ladder"),
	drawtype = "signlike",
	tiles = {"classic_mese_stuff_ladder.png"},
	inventory_image = "classic_mese_stuff_ladder.png",
	wield_image = "classic_mese_stuff_ladder.png",
	paramtype = "light",
	paramtype2 = "wallmounted",
	sunlight_propagates = true,
	walkable = false,
	climbable = true,
	is_ground_content = false,
	selection_box = {
		type = "wallmounted",
		--wall_top = = <default>
		--wall_bottom = = <default>
		--wall_side = = <default>
	},
	groups = {dig_immediate = 2},
	legacy_wallmounted = true,
    sound = {breaks = "default_dig_cracky"},
})
minetest.register_node("classic_mese_stuff:mese_lamp", {
    description = "Mese Lamp",
    tiles = {"classic_mese_stuff_lamp.png"},
    drawtype = "glasslike",
    paramtype = "light",
    sunlight_propagates = true,
    light_source = minetest.LIGHT_MAX,
    use_texture_alpha = "clip",
    groups = {dig_immediate = 2},
    sound = {breaks = "default_break_glass.1"},
})
minetest.register_craftitem("classic_mese_stuff:mese_stick", {
    description = "Mese Stick",
    inventory_image = "classic_mese_stuff_stick.png",
})

-- Crafting
minetest.register_craft({
    output = "classic_mese_stuff:mese_cobble 4",
    recipe = {
        {"default:mese"},
        {"default:cobble"},
    }
})
minetest.register_craft({
    output = "classic_mese_stuff:mese_glass 4",
    recipe = {
        {"default:glass"},
        {"default:mese"},
    }
})
minetest.register_craft({
	output = "classic_mese_stuff:ladder_mese 14",
	recipe = {
		{"classic_mese_stuff:mese_stick", "", "classic_mese_stuff:mese_stick"},
		{"classic_mese_stuff:mese_stick", "classic_mese_stuff:mese_stick", "classic_mese_stuff:mese_stick"},
		{"classic_mese_stuff:mese_stick", "", "classic_mese_stuff:mese_stick"},
	}
})
minetest.register_craft({
	output = "classic_mese_stuff:mese_stick 16",
	recipe = {
		{"default:mese"},
	}
})
minetest.register_craft({
    output = "classic_mese_stuff:sword_mese",
    recipe = {
        {"default:mese"},
        {"default:mese"},
        {"default:stick"},
    }
})
minetest.register_craft({
    output = "classic_mese_stuff:shovel_mese",
    recipe = {
        {"default:mese"},
        {"default:stick"},
        {"default:stick"},
    }
})
minetest.register_craft({
    output = "classic_mese_stuff:axe_mese",
    recipe = {
        {"default:mese", "default:mese"},
        {"default:mese", "default:stick"},
        {"", "default:stick"},
    }
})
minetest.register_craft({
    output = "classic_mese_stuff:mese_lamp",
    recipe = {
        {"", "default:mese", ""},
        {"default:glass", "default:torch", "default:glass"},
        {"", "default:mese", ""},
    }
})