local S = minetest.get_translator(minetest.get_current_modname())
local mofood_longdesc = S("A delicious dish made from fresh ingredients.")

potionmod = potionmod or {}

potionmod.potions = potionmod.potions or {}

function potionmod.register_potion_type(name, def)
    potionmod.potions[name] = def
end

function potionmod.apply_effect(player, effect_name, duration, strength)
    if effect_name == "speed" then
        local name = player:get_player_name()
        player:set_physics_override({speed = 1 + 0.5 * strength})
        minetest.after(duration, function()
            local p = minetest.get_player_by_name(name)
            if p then
                p:set_physics_override({speed = 1})
            end
        end)
    end
end


local function register_food_item(name, description, image, saturation, eat_value)
    minetest.register_craftitem(name, {
        description = description,
        _doc_items_longdesc = mofood_longdesc,
        inventory_image = image,
        groups = {food = 2, eatable = eat_value},
        _mcl_saturation = saturation,
        on_place = minetest.item_eat(eat_value),
        on_secondary_use = minetest.item_eat(eat_value),
    })
end

register_food_item("italian_food:pizza", S("Pizza"), "pizza.png", 16, 15)
register_food_item("italian_food:mushroom_pizza", S("Mushroom Pizza"), "mushroom_pizza.png", 16, 18)
register_food_item("italian_food:lasagna", S("Lasagna"), "lasagna.png", 13, 10)
register_food_item("italian_food:spaghetti", S("Tomato Spaghetti"), "spaghetti.png", 12, 10)
register_food_item("italian_food:dough", S("Dough"), "dough.png", 10, 10)
register_food_item("italian_food:spaghetti_raw", S("Raw Spaghetti"), "spaghetti_raw.png", 10, 10)
register_food_item("italian_food:raviolo_raw", S("Raw Raviolo"), "raviolo.png", 12, 12)
register_food_item("italian_food:gnocco_raw", S("Raw Gnocco"), "gnocco.png", 11, 10)
register_food_item("italian_food:fazzoletto_raw", S("Raw Fazzoletto"), "fazzoletti.png", 11, 11)
register_food_item("italian_food:bruschetta", S("Bruschetta"), "bruschetta.png", 20, 18)
register_food_item("italian_food:canoli", S("Cannoli"), "canoli.png", 20, 18)
register_food_item("italian_food:mozzarella", S("Mozzarella"), "mozzarella.png", 8.5, 9)
register_food_item("italian_food:sheep_mil_bucket", S("Sheep Milk Bucket"), "sheep_milk_bucket.png", 8.5, 9)
register_food_item("italian_food:sheep_cheese", S("Sheep Cheese"), "sheep_cheese.png", 9,8)
register_food_item("italian_food:tomato", S("Tomato"), "tomato.png", 8.5, 9)
register_food_item("italian_food:basil", S("Basil"), "basil.png", 3,4)
register_food_item("italian_food:tomato_sauce", S("Tomato Sauce"), "tomato_sauce.png", 7.5,8)
register_food_item("italian_food:pesto_sauce", S("Pesto Sauce"), "pesto_sauce.png", 7.5,8)
register_food_item("italian_food:tiramisu", S("Tiramisu"), "tiramisu.png", 12, 8)
register_food_item("italian_food:ice_cream", S("Chocolate Ice Cream"), "ice_cream.png", 8, 12)
register_food_item("italian_food:cone", S("Ice Cream Cone"), "cone.png", 4, 6)
register_food_item("italian_food:panettone", S("Panettone"), "panettone.png", 7, 8)
register_food_item("italian_food:pandoro", S("Pandoro"), "pandoro.png", 7, 8)
register_food_item("italian_food:coffee", S("Coffee"), "coffee.png", 7.5,8)
register_food_item("italian_food:sunflowerolio",S("Sunflower Oil"), "sunfloweroil.png", 5, 3)    
register_food_item("italian_food:pork_jowl",S("Pork Jowl"), "pork_jowl.png", 5, 3)

-- Crafting
minetest.register_craft({
    output = "italian_food:dough",
    recipe = {
        {"", "mcl_farming:wheat_item", ""}, 
        {"mcl_farming:wheat_item", "mcl_farming:wheat_item", "mcl_farming:wheat_item"}, --good
        {"", "mcl_farming:wheat_item", ""}, 
    },
})
minetest.register_craft({
    output = "italian_food:pizza",
    recipe = {
        {"", "italian_food:mozzarella", ""}, 
        {"italian_food:tomato_sauce", "italian_food:tomato_sauce", "italian_food:tomato_sauce"}, --good
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
    },
})
minetest.register_craft({
    output = "italian_food:lasagna",
    recipe = {
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
        {"italian_food:tomato_sauce", "italian_food:tomato_sauce", "italian_food:tomato_sauce"}, --good
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
    },
})
minetest.register_craft({
    output = "italian_food:mushroom_pizza",
    recipe = {
        {"", "mcl_mushrooms:mushroom_brown", ""},   --good
        {"", "italian_food:pizza", ""}, 
        {"", "", ""}, 
    },
})
minetest.register_craft({
	output = "italian_food:spaghetti",
	recipe = {
        {"", "italian_food:tomato_sauce", ""}, 
        {"", "italian_food:spaghetti_raw", ""}, --good
        {"", "", ""}, 
    },
})
minetest.register_craft({
	output = "italian_food:bruschetta",
	recipe = {
        {"", "italian_food:tomato", ""}, 
        {"", "mcl_farming:bread", ""}, --good
        {"", "", ""}, 
    },
})

minetest.register_craft({
    output = "italian_food:tiramisu",
    recipe = {
        {"mcl_cocoas:cocoa_beans", "mcl_core:sugar", "mcl_cocoas:cocoa_beans"},
		{"italian_food:coffee", "mcl_throwing:egg", "italian_food:coffee"},      -- good
        {"", "", ""},
    },
})

minetest.register_craft({
    output = "italian_food:gnocco_raw",
    recipe = {
        {"", "mcl_farming:potato_item", ""},
        {"mcl_farming:potato_item", "mcl_farming:potato_item", "mcl_farming:potato_item"},      --good
        {"", "mcl_farming:potato_item", ""},
    },
})

minetest.register_craft({
    output = "italian_food:tomato_sauce",
    recipe = {
        {"","italian_food:tomato", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
    output = "italian_food:pesto_sauce",
    recipe = {
        {"","italian_food:basil", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
    output = "italian_food:sunflowerolio",
    recipe = {
        {"","mcl_flowers:sunflower", ""}, --good
        {"", "mcl_potions:water", ""},     
        {"", "", ""},
    },
})
minetest.register_craft({
    output = "italian_food:coffee",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "mcl_potions:water", ""},      --good
        {"", "", ""},
    },
})
minetest.register_craft({
	type = "cooking",
	output = "italian_food:mozzarella",                                  --good
	recipe = "mcl_mobitems:milk_bucket",
	replacements = {
		{"mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty"},
	},
})
minetest.register_craft({
	type = "cooking",
	output = "italian_food:sheep_cheese",                                  --good
	recipe = "italian_food:sheep_milk_bucket",
	replacements = {
		{"mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty"},
	},
})
minetest.register_craft({
    output = "italian_food:ice_cream",
    recipe = {
        {"mcl_core:sugar","mcl_core:ice", "mcl_core:sugar"},
        {"", "mcl_cocoas:cocoa_beans", ""},      --good
        {"", "italian_food:cone", ""},
    },
})
minetest.register_craft({
    output = "italian_food:cone",
    recipe = {
        {"","mcl_core:sugar", ""},
        {"", "mcl_mobitems:milk_bucket", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:pandoro",
    recipe = {
        {"","mcl_core:sugar", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:panettone",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})
minetest.register_craft({
    output = "italian_food:raviolo_raw",
    recipe = {
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
        {"italian_food:dough", "mcl_mobitems:beef", "italian_food:dough"},      --good
        {"italian_food:dough", "italian_food:dough", "italian_food:dough"}, 
    },
})
minetest.register_craft({
    output = "italian_food:cannoli",
    recipe = {
        {"","mcl_cocoas:cocoa_beans", ""},
        {"", "italian_food:dough", ""},      --good
        {"", "mcl_throwing:egg", ""},
    },
})


-- plants
-- basil plant
minetest.register_node("italian_food:basil_plant", {
    description = S("Basil Plant"),
    drawtype = "plantlike",
    tiles = {"basil_plant.png"},
    groups = {snappy = 3, flammable = 2, plant = 1},
    sounds = default and default.node_sound_leaves_defaults() or nil,
    drop = "italian_food:basil",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
})
minetest.register_abm({
    nodenames = {"group:grass"},
    neighbors = {"group:soil"},
    interval = 60,
    chance = 30, 
    action = function(pos, node)
        local basil_pos = {x = pos.x, y = pos.y + 1, z = pos.z}
        if minetest.get_node(basil_pos).name == "air" then
            if minetest.get_node(pos).name == "group:grass" then
                minetest.set_node(basil_pos, {name = "italian_food:basil_plant"})
            end
        end
    end
})
-- tomato plant
minetest.register_node("italian_food:tomato_plant", {
    description = S("Tomato Plant"),
    drawtype = "plantlike",
    tiles = {"tomato_plant.png"},
    groups = {snappy = 3, flammable = 2, plant = 1},
    sounds = default and default.node_sound_leaves_defaults() or nil,
    drop = "italian_food:tomato",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
})
minetest.register_abm({
    nodenames = {"group:grass"},
    neighbors = {"group:soil"},
    interval = 60,
    chance = 30, 
    action = function(pos, node)
        local tomato_pos = {x = pos.x, y = pos.y + 1, z = pos.z}
        if minetest.get_node(tomato_pos).name == "air" then
            minetest.set_node(tomato_pos, {name = "italian_food:tomato_plant"})
        end
    end
})

--achievements
awards.register_achievement("italian_food:pizza_eating", {
	title = S("Welcome to Italy!"),
	icon = "pizza.png",
	description = S("Eat a pizza slice."),
	trigger = {
		type = "eat",
		item= "italian_food:pizza",
		target = 1,
	}
})
awards.register_achievement("italian_food:mushroom_pizza_eating", {
	title = S("Mushrooms? Don't tell Mario!"),
	icon = "mushroom_pizza.png",
	description = S("Eat a pizza slice with mushrooms."),
	trigger = {
		type = "eat",
		item= "italian_food:mushroom_pizza",
		target = 1,
	}
})
awards.register_achievement("italian_food:bruschetta_eating", {
	title = S("A simple snack!"),
	icon = "bruschetta.png",
	description = S("Eat a Bruschetta."),
	trigger = {
		type = "eat",
		item= "italian_food:bruschetta",
		target = 1,
	}
})

-- items that aren't food
minetest.register_tool("italian_food:rolling_pin", {
    description = S("Rolling Pin"),
    inventory_image = "rolling_pin.png",
    tool_capabilities = {
        full_punch_interval = 1.2,
        max_drop_level = 0,
        groupcaps = {
            crumbly = {times = {[1] = 2.0, [2] = 1.00, [3] = 0.50}, uses = 25, maxlevel = 1},
        },
        damage_groups = {fleshy = 1},
    },
    groups = {wooden_tool = 1},
})
minetest.register_craft({
    output = "italian_food:rolling_pin",
    recipe = {
        {"", "mcl_core:stick", ""},
        {"", "mcl_core:stick", ""},
        {"", "mcl_core:stick", ""},
    },
})

minetest.register_node("italian_food:cheese_rack", {
    description = "Cheese Rack",
    tiles = {"cheese_rack_top.png", "cheese_rack_bottom.png", "cheese_rack_side.png"},
    groups = {choppy = 2, oddly_breakable_by_hand = 2},
    sounds = mcl_sounds.node_sound_wood_defaults(),
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local inv = clicker:get_inventory()
        local name = itemstack:get_name()
        if name == "italian_food:fresh_cheese" then
            minetest.set_node(pos, {name = "italian_food:cheese_rack_with_cheese", param2 = 0})
            if not minetest.is_creative_enabled(clicker:get_player_name()) then
                itemstack:take_item()
            end
            return itemstack
        end
    end,
})
minetest.register_node("italian_food:cheese_rack_with_cheese", {
    description = "Cheese Rack (Aging Cheese)",
    tiles = {
        "cheese_rack_top.png", "cheese_rack_bottom.png",
        "cheese_rack_side.png", "cheese_rack_side.png",
        "cheese_rack_side.png", "cheese_rack_front_cheese.png"
    },
    groups = {choppy = 2, oddly_breakable_by_hand = 2, not_in_creative_inventory = 1},
    drop = "italian_food:cheese_rack",
sounds = mcl_sounds.node_sound_wood_defaults(),
    on_timer = function(pos, elapsed)
        minetest.set_node(pos, {name = "italian_food:sheep_cheese"})
    end,
    on_construct = function(pos)
        minetest.get_node_timer(pos):start(120)  -- 120 secondi = 2 minuti
    end
})
minetest.register_node("italian_food:cheese_rack_aged", {
    description = "Cheese Rack (Aged Cheese)",
    tiles = {
        "cheese_rack_top.png", "cheese_rack_bottom.png",
        "cheese_rack_side.png", "cheese_rack_side.png",
        "cheese_rack_side.png", "cheese_rack_front_aged.png"
    },
    groups = {choppy = 2, oddly_breakable_by_hand = 2, not_in_creative_inventory = 1},
    drop = {
        max_items = 2,
        items = {
            {items = {"italian_food:sheep_cheese"}},
            {items = {"italian_food:cheese_rack"}},
        },
    },
    sounds = mcl_sounds.node_sound_wood_defaults(),
})








-- potion idea?
mcl_potions.register_potion({
	name = "sugar_coffe",
	desc_suffix = S("of Sugar Coffe"),
	_tt = nil,
	_longdesc = S("Increases walking, placing and digging speed and jump boost."),
	color = "#531B00",
	_effect_list = {
		swiftness = {},
        haste = {},
        leaping = {},
	},
	has_arrow = false,
})






































-- Hey doesn't tiramisu also use coffee and eggs? >;p         Inspired by a real dessert and a caffeine-fueled coding session!

