-- Support de l’internationalisation
-- Internationalization support
local S = minetest.get_translator(minetest.get_current_modname())

local mod_storage = minetest.get_mod_storage()
local hidden_players = {}

-- Charge les données persistantes
-- Load persistent data
local function load_player_state(name)
    local value = mod_storage:get_string(name)
    return value == "hidden"
end

-- Sauvegarde les données persistantes
-- Save persistent data
local function save_player_state(name, hidden)
    if hidden then
        mod_storage:set_string(name, "hidden")
    else
        mod_storage:set_string(name, "visible")
    end
end

-- Appliquer l’effet d’armure invisible
-- Apply invisible armor effect
local function hide_armor(player)
	local name = player:get_player_name()
	if not name or not armor.textures then return end

	local skin = armor.textures[name] and armor.textures[name].skin or "character.png"
	local props = player:get_properties()
	props.textures = {
		skin,
		"blank.png", "blank.png", "blank.png",
		"blank.png", "blank.png"
	}
	player:set_properties(props)
end

-- Commande principale
-- Main command
minetest.register_chatcommand("armor_view", {
	params = "<on|off|status>",
	description = S("Hide or show the 3D armor"),
	func = function(name, param)
		local player = minetest.get_player_by_name(name)
		if not player then return false, "Player not found." end

		param = param:lower()
		if param == "off" then
			-- Masquer l’armure 3D
			-- Hide the 3D armor
			hidden_players[name] = true
			save_player_state(name, true)
			hide_armor(player)
			return true, S("3D armor hidden.")
		elseif param == "on" then
			-- Réafficher l’armure 3D
			-- Show the 3D armor again
			hidden_players[name] = nil
			save_player_state(name, false)
			armor:update_player_visuals(player)
			return true, S("3D armor shown again.")
		elseif param == "status" or param == "" then
			-- Afficher l’état actuel de l’armure 3D
			-- Show current 3D armor status
			if hidden_players[name] then
				return true, S("3D armor is currently **hidden**.")
			else
				return true, S("3D armor is currently **visible**.")
			end
		else
			return false, "Usage : /armor_view <on|off|status>"
		end
	end
})

-- Appliquer l'état au chargement du joueur
-- Apply saved state on player join
minetest.register_on_joinplayer(function(player)
	local name = player:get_player_name()
	if not name then return end
	if load_player_state(name) then
		hidden_players[name] = true
		minetest.after(1, function()
			hide_armor(player)
		end)
	end
end)
