MN = "lukasblocks:"

minetest.register_node(MN.. "polished_stone_brick", {
	description = "Polished Stone Bricks",
	groups = {cracky = 2},
	tiles = {"polished_stone_brick.png"},
})

minetest.register_node(MN.. "psb_half_slab", {
	description = "Polished Stone Brick Half Slab",
	tiles = {"polished_stone_brick.png"},
	groups = {cracky = 2},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	node_box = {
		type = "fixed",
		fixed = {{-0.5, -0.5, -0.5, 0, 0, 0.5}},}})

minetest.register_craft({
	output = MN.. "psb_half_slab",
	recipe = {{MN.. "psb_slab", MN.. "chisel"}},
	replacements = {{MN.. "chisel",MN.. "chisel"}}
})

minetest.register_node(MN.. "psb_slab", {
	description = "Polished Stone Brick Slab",
	tiles = {"polished_stone_brick.png"},
	groups = {cracky = 2},
	drawtype = "nodebox",
	paramtype = "light",
	node_box = {
		type = "fixed",
		fixed = {{-0.5, -0.5, -0.5, 0.5, 0, 0.5}},}})

minetest.register_craft({
	output = MN.. "psb_slab",
	recipe = {{MN.. "polished_stone_brick", MN.. "chisel"}},
	replacements = {{MN.. "chisel",MN.. "chisel"}}
})

minetest.register_node(MN.. "psb_stair", {
	description = "Polished Stone Brick Stair",
	tiles = {"polished_stone_brick.png"},
	groups = {cracky = 2},
	drawtype = "nodebox",
	paramtype = "light",
	paramtype2 = "facedir",
	node_box = {
		type = "fixed",
		fixed = {{-0.5, -0.5, -0.5, 0.5, 0, 0.5},
		{-0.5, 0, 0, 0.5, 0.5, 0.5}}}})

minetest.register_craft({
	output = MN.. "psb_stair",
	recipe = {{MN.. "psb_slab", MN.. "psb_half_slab"}},
})

minetest.register_node(MN.. "smooth_stone_block", {
	description = "Smooth Stone Block",
	groups = {cracky = 2},
	tiles = {"smooth_stone.png"},
})

minetest.register_craft({
	type = "cooking",
	recipe = "default:stone_block",
	output =  MN.. "smooth_stone_block",
})

minetest.register_node(MN.. "chiseled_stone_column", {
	description = "Chiseled Stone Column",
	groups = {cracky = 2},
	tiles = {"column_top.png", "column_top.png", "chiseled_stone_column_side.png"},
})

minetest.register_craft({
	output = MN.. "chiseled_stone_column",
	recipe = {{MN.. "stone_column", MN.. "chisel"}},
	replacements = {{MN.. "chisel",MN.. "chisel"}}
})

minetest.register_node(MN.. "stone_column", {
	description = "Stone Column",
	groups = {cracky = 2},
	tiles = {"column_top.png", "column_top.png", "column_side.png"},
})

minetest.register_node(MN.. "planks_block", {
	description = "Planks Block",
	groups = {cracky = 2},
	tiles = {"planks_block.png"},
})

minetest.register_node(MN.."wooden_lamp", {
    description = "Wooden Lamp",
    groups = {choppy = 2},
    tiles = {"wooden_lamp.png"},
    light_source = 12,
})

minetest.register_craft({
	recipe = {{MN.."planks_block", "default:torch", MN.."saw"}},
	output =  MN.. "wooden_lamp",
})

minetest.register_craftitem(MN.."plank", {
    description = "Wooden Plank",
    inventory_image = "plank.png"
})

minetest.register_craft({
	output = MN.. "plank 2",
    recipe = {{MN.."stone_nail", "group:wood", MN.."stone_nail"}}
})

minetest.register_craftitem(MN.."stone_nail", {
    description = "Stone Nail",
    inventory_image = "stone_nail.png"
})

minetest.register_craft({
	output = MN.. "stone_nail 16",
    recipe = {{MN.."chisel", MN.."smooth_stone_block"}}
})

minetest.register_node(MN.. "carpenters_table", {
	description = "Carpenter's Table",
	groups = {cracky = 1},
	tiles = {"mason_top.png", "planks_block.png", "carpenters_table_side.png"},
	
	after_place_node = function(pos, placer)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec",
                "formspec_version[4]" ..
                "size[20,20]" ..
                "label[1,1;Carpenter's Table Recipes]" ..
                "button_exit[15,1;2,1;Exit;Exit]" ..
                "label[3,3; To craft something leftclick the table with the desired material]" ..
				"label[3,5; Wooden Plank ---> Planks Block]")
	end,

	on_punch = function(pos, node, puncher, pointed_thing)
		if not (puncher and puncher:is_player()) then
			return
		end

		local wielded_item = puncher:get_wielded_item():get_name()
		if wielded_item == MN.."plank" then
			local inv = puncher:get_inventory()
			inv:add_item("main", ItemStack(MN.. "planks_block"))
			inv:remove_item("main", ItemStack(MN.. "plank"..1))
		end
	end
})

minetest.register_craft({
	output = MN.. "carpenters_table",
	recipe = {{"", "default:steel_ingot", ""},
	{MN.."plank", "default:wood", MN.."plank"},
	{"", MN.."plank", ""}},
})

minetest.register_node(MN.. "masons_table", {
	description = "Mason's Table",
	groups = {cracky = 1},
	tiles = {"mason_top.png", "mason_bottom.png", "mason_side.png"},
	
	after_place_node = function(pos, placer)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec",
                "formspec_version[4]" ..
                "size[20,20]" ..
                "label[1,1;Mason's Table Recipes]" ..
                "button_exit[15,1;2,1;Exit;Exit]" ..
                "label[3,3; To craft something leftclick the table with the desired material]" ..
				"label[3,5; Stone Brick ---> Polished Stone Brick]"..
				"label[3,4; Stone ---> Column]")
	end,

	on_punch = function(pos, node, puncher, pointed_thing)
		if not (puncher and puncher:is_player()) then
			return
		end

		local wielded_item = puncher:get_wielded_item():get_name()
		if wielded_item == "default:stonebrick" then
			local inv = puncher:get_inventory()
			inv:add_item("main", ItemStack(MN.. "polished_stone_brick"))
			inv:remove_item("main", ItemStack("default:stonebrick".." "..1))
		elseif wielded_item == "default:stone" then
			local inv = puncher:get_inventory()
			inv:add_item("main", ItemStack(MN.. "stone_column"))
			inv:remove_item("main", ItemStack("default:stone".." "..1))
		end
	end
})

minetest.register_tool(MN.. "chisel", {
	description = "Chisel",
	inventory_image = "chisel.png"
})

minetest.register_craft({
	output = MN.. "chisel",
	recipe = {{"", "default:steel_ingot", ""},
	{"default:stick", "", ""}},
})

minetest.register_tool(MN.."saw", {
	description = "Saw",
	inventory_image = "saw.png"
})

minetest.register_craft({
	output = MN.. "saw",
	recipe = {{"", MN.."stone_nail", ""},
	{"default:steel_ingot", "default:stick", "dye:red"}},
})