# COMPUTING API

The 'COMPUTING API' provides methods needed for you to create your own 'computing apps' through your own mod.

-------------------------------------------

## Show Smartphone Screen

````lua
modComputing.show_smartphone(player)
````

-------------------------------------------

## Get Smartphone Background FormSpec

Can you add your own Fields on top of a smartphone background formspec.

### Syntaxe:

````lua
modComputing.smartphone.getFormBackground()
````

### Sample: Add 'Write your name' field
````lua
local playername = player:get_player_name()
local formspec = ""
..modComputing.smartphone.getFormBackground()
.."field[1.00,2.25;4.5,0.5;txtName;Write your name;"..playername.."]"
core.show_formspec(playername, "formMyModName", formspec)
-- See more methods in: https://github.com/minetest/minetest/blob/master/doc/lua_api.md
````

* formspec version = 6
* formsoec width = 05.6
* formsoec height = 10.0


-------------------------------------------

## Adding an App from your Mod

### Syntaxe:
````lua
   modComputing.add_app("<app_id>", {
      icon_name = "<app_button_name>",
      icon_type = "<button_type>", --types: button/button_exit
      icon_title = "<app_name>",
      icon_descryption = "<app_descryption>",
      icon_image = "<app_image>",
      is_visible = function(player)
         return true 
         -- The button icon of app only is visible if return true.
      end,
      on_iconclick = function(clicker)
         -- Put here your functions!
      end,
   })
````

### Sample 1: Hello World
````lua
   if core.global_exists("modComputing") then
      modComputing.add_app("my_mod:app_hello_world", {
         icon_name = "btnShowAppHelloWorld",
         icon_type = "button", 
         icon_title = "HELLO WORLD",
         icon_descryption = "This is a sample of 'hello world' app.",
         icon_image = "icon_app.png",
         on_iconclick = function(clicker)
            local playername = clicker:get_player_name()
            core.chat_send_player(playername,
               ("The '%s' pressed '%s' button icon app!"):format(
                  playername, 
                  btnShowAppHelloWorld
               )
            )
            -- Put more lines if you want!
            -- See more methods in: https://github.com/minetest/minetest/blob/master/doc/lua_api.md
         end,
      })
   end
````

### Sample 2: Shut down of server.
````lua
   if core.global_exists("modComputing") then
      modComputing.add_app("my_mod_app:btnShutdownServer", {
         icon_name = "btnShutdownServer",
         icon_type = "button_exit", 
         icon_title = "SHUTDOWN",
         icon_descryption = "This is a sample of 'Shutdown Server' app.",
         icon_image = "icon_shutdown.png",
         is_visible = function(player)
            return core.check_player_privs(player, {server = true})
         end,
         on_iconclick = function(clicker)
            local playername = clicker:get_player_name()
            core.request_shutdown(
               ("The administrator '%s' has requested that the server be shut down."):format(playername),
               false, --If reconnect
               60 --delay in seconds
            )
            -- See more methods in: https://github.com/minetest/minetest/blob/master/doc/lua_api.md
         end,
      })
   end
````

-------------------------------------------