modComputing.apps = { }

modComputing.debug = function(text, playername)
	if text ~= nil
		and type(text) == "string"
		and text ~= ""
	then
		if core.settings:get_bool(modComputing.modname..".debug") then
			if playername ~= nil
				and type(playername) == "string"
				and playername ~= ""
			then
				local player = core.get_player_by_name(playername)
				if player ~=nil and player:is_player() then
					core.chat_send_player(
						playername, text
					)
					core.log('action',"["..modComputing.modname:upper()..":DEBUG:"..playername.."] "..text)
				else
					core.log('error',
						"["..modComputing.modname:upper()..":DEBUG] "
						..(
							"Unable to address debug for player '%s'."
						):format(dump(playername))
					)
					core.log('action',"["..modComputing.modname:upper()..":DEBUG] "..text)
				end
			else
				core.chat_send_all(text)
				core.log('action',"["..modComputing.modname:upper()..":DEBUG] "..text)
			end
		end
	end
end

modComputing.log = function(text)
	local sufix = "["..modComputing.modname:upper()..":ERRO] "
	core.chat_send_all(sufix..text)
	core.log('action',sufix..text)
	return sufix..text
end

modComputing.add_app = function(appname, def)
	--modComputing.debug("[debug] modComputing.add_app(appname="..dump(appname)..", def) : def="..dump(def))
	if type(appname)=="string" and appname~="" then
		if type(modComputing.apps[appname])~="table" then
			if type(def.icon_name)=="string" and def.icon_name~="" then
				if type(def.icon_title)=="string" and def.icon_title~="" then
					if type(def.icon_descryption)=="string" and def.icon_descryption~="" then
						if type(def.icon_type)=="string" and def.icon_type~="" then
							if type(def.icon_image)=="string" and def.icon_image~="" then
								if type(def.on_iconclick)=="function" then
									modComputing.apps[appname] = {
										icon_name = def.icon_name,
										icon_title = def.icon_title,
										icon_descryption = def.icon_descryption,
										icon_type = def.icon_type,
										icon_image = def.icon_image,
										is_visible = def.is_visible or true,
										on_iconclick = def.on_iconclick,
									}
									return true
								else
									--modComputing.debug("[debug] modComputing.add_app() : H")
									return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.on_iconclick' variable!")
								end
							else
								--modComputing.debug("[debug] modComputing.add_app() : G")
								return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.icon_image' variable!")
							end
						else
							--modComputing.debug("[debug] modComputing.add_app() : F")
							return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.icon_type' variable!")
						end
					else
						--modComputing.debug("[debug] modComputing.add_app() : E")
						return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.icon_descryption' variable!")
					end	
				else
					--modComputing.debug("[debug] modComputing.add_app() : D")
					return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.icon_title' variable!")
				end
			else
				--modComputing.debug("[debug] modComputing.add_app() : C")
				return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'def.icon_name' variable!")
			end
		else
			--modComputing.debug("[debug] modComputing.add_app() : B")
			return false, modComputing.log("modComputing.add_app(appname, def) : "..
				("Unable to repeatedly add appname '%s'!"):format(appname)
			)
		end
	else
		--modComputing.debug("[debug] modComputing.add_app() : A")
		return false, modComputing.log("modComputing.add_app(appname, def) : Invalid 'appname' variable!")
	end
end

modComputing.add_test_apps = function()
   --[[  
   if core.settings:get_bool(modComputing.modname..".debug") then
   	modComputing.add_app("computing:btnMinetest", {
   		icon_name = "btnMinetest",
   		icon_type = "button", --types: button/button_exit
   		icon_title = "MINETEST",
   		icon_descryption = "Jogo de Voxel muito legal.",
   		icon_image = "icon_smartphone_128x128.png",
   		--on_iconclick = modComputing.show_smartphone_config,
   		on_iconclick = function()
   			core.chat_send_all("Button 'btnMinetest' pressed!")
   		end,
   	})
   	modComputing.add_app("computing:btnDoom", {
   		icon_name = "btnDoom",
   		icon_type = "button", --types: button/button_exit
   		icon_title = "DOOM",
   		icon_descryption = "Jogo de tiro em primeira pessoa.",
   		icon_image = "icon_smartphone_128x128.png",
   		--on_iconclick = modComputing.show_smartphone_config,
   		on_iconclick = function()
   			core.chat_send_all("Button 'btnDoom' pressed!")
   		end,
   	})
   	modComputing.add_app("computing:btnMastodon", {
   		icon_name = "btnMastodon",
   		icon_type = "button", --types: button/button_exit
   		icon_title = "MASTODON",
   		icon_descryption = "Uma rede social muito legal.",
   		icon_image = "icon_smartphone_128x128.png",
   		--on_iconclick = modComputing.show_smartphone_config,
   		on_iconclick = function()
   			core.chat_send_all("Button 'btnMastodon' pressed!")
   		end,
   	})
   	modComputing.add_app("computing:btnLockPhone", {
   		icon_name = "btnLockPhone",
   		icon_type = "button_exit", --types: button/button_exit
   		icon_title = "LOCK",
   		icon_descryption = "Bloqueia tela do Smartphone.",
   		icon_image = "icon_smartphone_128x128.png",
   		--on_iconclick = modComputing.show_smartphone_config,
   		on_iconclick = function()
   			core.chat_send_all("Button 'btnLockPhone' pressed!")
   		end,
   	})
   end
   --[[ ]]
end

modComputing.get_appnames = function()
	local appnames = {}
	for k,v in pairs(modComputing.apps) do
		table.insert(appnames, k)
	end
	table.sort(appnames)
	return appnames
end

modComputing.get_apps = function()
	return modComputing.apps
end

modComputing.get_app = function(appname)
	if type(appname)=="string" and appname~="" then
		if type(modComputing.apps[appname])=="table" then
			return modComputing.apps[appname]
		else
			return false, modComputing.log("modComputing.get_app(appname) : "..
				("Cannot find appname '@1'!"):format(appname)
			)
		end
	else
		return false, modComputing.log("modComputing.get_app(appname) : Invalid 'appname' variable!")
	end
end

modComputing.getTextNowWeekDay3S = function()
	local txtWeekDays3S = {
		modComputing.translate("Sun"), --Sunday
		modComputing.translate("Mon"), --Monday
		modComputing.translate("Tue"), --Tuesday
		modComputing.translate("Wed"), --Wednesday
		modComputing.translate("Thu"), --Thursday
		modComputing.translate("Fri"), --Friday
		modComputing.translate("Sat"), --Saturday
	}
	local totalDays = core.get_day_count() + 1
	local nowRow = math.floor((totalDays-1)/7)+1
	local nowCol = totalDays - ((nowRow-1)*7)
	return txtWeekDays3S[nowCol]

end

modComputing.getTextNowTime = function()
	local current_time = math.floor(core.get_timeofday() * 1440)
	local minutes = current_time % 60
	local hour = (current_time - minutes) / 60
	return ("%02d:%02d"):format(hour, minutes)
end

modComputing.getNowYear = function()
   local totalDays = core.get_day_count()
	local nowYear = totalDays/(28*4)
	return nowYear
end

modComputing.getTextNowDate = function()
	local totalDays = core.get_day_count()
	local nowMonth = (math.floor(totalDays/28)%4)+1
	local txtMonths3S = {
		modComputing.translate("SPR"),
		modComputing.translate("SUM"), 
		modComputing.translate("AUT"), 
		modComputing.translate("WIN"),
	} --SPRING, SUMMER, AUTUMN, WINTER
	local nowDay = math.floor(totalDays%28)+1
	--local nowDate = ("%04d-%3s-%02d"):format((nowYear+1), txtMonths3S[nowMonth], nowDay)
	local nowDate = modComputing.translate(
	   "@1-@2",
	   ("%3s"):format(txtMonths3S[nowMonth]),
	   ("%02d"):format(nowDay)
	)
	--:format((nowYear+1), txtMonths3S[nowMonth], nowDay)
	return nowDate
end

modComputing.doJumpDay = function(pular)
	if type(tonumber(pular)) == "number" and tonumber(pular) >= 1 then
			--modComputing.debug("pulando = "..pular)
			for n = 1, tonumber(pular) do
				core.set_timeofday(0.0)
				core.set_timeofday(5/24)  --It goes to 05h in the morning, time to wake up.
			end
			local diaAtual = core.get_day_count()
			--core.chat_send_player(playername, 
			core.chat_send_all(
				"[".. core.colorize("#00FFFF", modComputing.modname:upper()).."] "
				..modComputing.translate(
					"Now this is the day @1°.",
					string.format("%02d", diaAtual)
				)
				
			)
			--modComputing.update_cicle()
		return true
	else
		return false
	end
end
