-- skipped days
core.register_chatcommand("jumpday", {
	params = "[number]",
	description = modComputing.translate(
		"Forces the calendar to jump a certain number of days.\n"
		.."Maximum number of 112 days. Need 'settime' privilege."
	),
	func = function(playername, param)
		local isPriv = core.check_player_privs(playername, {settime=true})
		if isPriv then
			local pular = 0
			--mobs_7dtc.debug("type('"..param.."') = "..type(param))
			if param == "" or tonumber(param) == nil or tonumber(param) < 1 then
				pular = 1
			elseif tonumber(param) <= 112 then
				pular = tonumber(param)
			else
				core.chat_send_player(
					playername, 
					"[".. core.colorize("#FF0000", modComputing.modname:upper()..":"..modComputing.translate("FAILURE")).."] "
					..modComputing.translate(
						"The maximum number of days is exactly '@1'!!!", 
						core.colorize("#FF0000","112")
					)
				)
				return true --false  = quando o comando falha.
			end
			modComputing.doJumpDay(pular)
			return true --true=sucesso
		else
			core.chat_send_player(
				playername, 
				"[".. core.colorize("#FF0000", modComputing.modname:upper()..":"..modComputing.translate("FAILURE")).."] "
				..modComputing.translate(
					"You do not have the '@1' privilege to execute this command!!!", 
					core.colorize("#00FF00","settime")
				)
			)
		end
	end,
})
