modComputing.smartphone = {
   maxCol = 2,
   maxRow = 3,
   offSetX = 1.00,
   offSetY = 2.25,
   marginConteinerX = 0.50,
   marginConteinerY = 0.25,
   sizeButtonX = 1.50,
   sizeButtonY = 1.50,
}

modComputing.getTextClockBar = function()
	--return modComputing.getTextNowWeekDay3S()..", "..modComputing.getTextNowDate().." "..modComputing.getTextNowTime()
	return modComputing.translate(
	   "@1, @2 @3", 
	   modComputing.getTextNowWeekDay3S(),
	   modComputing.getTextNowDate(),
	   modComputing.getTextNowTime()
	)
end

modComputing.smartphone.getFormSpec = function(player)
   local formspec = ""
   ..modComputing.smartphone.getFormBackground()
   ..modComputing.smartphone.getAppListConteiner(player)
	return formspec
end

modComputing.smartphone.getFormBackground = function()
	local formspec = ""
	.."formspec_version[6]"
	.."size["..(10*271/484)..",10.0,true]"
	.."no_prepend[]"
	.."bgcolor[#08080844;true]" --Padrão: #080808BB | true = 100% transparente
	.."style_type[image_button;font=normal;font_size=11;textcolor=#FFFFFF]"
	.."style_type[image_button_exit;font=normal;font_size=11;textcolor=#FFFFFF]"
	--.."background[-0.75,-2.00;"..(10*271/484)..",10.0;text_smartphone_271x484.png;true]"
	.."image[0,0;"..(10*271/484)..",10.0;text_smartphone_271x484.png;true]"
	.."style_type[label;font=mono;font_size=10;textcolor=#FFFFFF]"
	.."label[0.75,1.975;"..core.formspec_escape(modComputing.getTextClockBar()).."]"
	return formspec
end

modComputing.smartphone.getAppListConteiner = function(player)
	local playername = player:get_player_name()
	local formspec = ""
	.."style_type[container;font=normal;font_size=7;textcolor=#FFFFFF]"
	--.."button_exit[0.75,2.50;1.5,1.5;btnClose;"..core.formspec_escape(modComputing.translate("Banana\nStore")).."]"
	
	if type(modComputing.show_page)~="table" then
	   modComputing.show_page = { }
	end
	if type(modComputing.show_page[playername])~="number" 
	   or modComputing.show_page[playername] < 0 
	then
	   modComputing.show_page[playername] = 0
	end
	
	local appsCount = 0
	local appnames = modComputing.get_appnames()
	local maxCol = modComputing.smartphone.maxCol
	local maxRow = modComputing.smartphone.maxRow
	local offSetX = modComputing.smartphone.offSetX
	local offSetY = modComputing.smartphone.offSetY
	local marginConteinerX = modComputing.smartphone.marginConteinerX
	local marginConteinerY = modComputing.smartphone.marginConteinerY
	local sizeButtonX = modComputing.smartphone.sizeButtonX
	local sizeButtonY = modComputing.smartphone.sizeButtonY
	
	for k,v in pairs(appnames) do
   	local apps = modComputing.get_apps()
		local icon_name = apps[v].icon_name
		local icon_title = apps[v].icon_title
		local icon_descryption = apps[v].icon_descryption
		local icon_type = apps[v].icon_type
		local icon_image = apps[v].icon_image
		local on_iconclick = apps[v].on_iconclick
		local is_visible = apps[v].is_visible
   	--modComputing.debug("apps = "..dump(apps) --[[, playername--]])
   	--modComputing.debug("is_visible = "..dump(is_visible) --[[, playername--]])
		
	   if (type(is_visible)=="boolean" and is_visible == true) 
		   or (type(is_visible)=="function" and is_visible(player))
		then
   		appsCount = appsCount + 1		
   		local page = math.floor((appsCount - 1) / (maxRow * maxCol)) --math.floor : arredonda sempre para menos
   		if page == modComputing.show_page[playername] then
      		local iconInPage = appsCount - math.floor(page * maxRow * maxCol)
      		local iconRow = math.floor((iconInPage - 1) / maxCol)
      		local iconCol = (iconInPage - 1) % maxCol
      		
      		--SAMPLE: image_button[<X>,<Y>;<W>,<H>;<texture name>;<name>;<label>;<noclip>;<drawborder>;<pressed texture name>]
      		--SAMPLE: image_button_exit[<X>,<Y>;<W>,<H>;<texture name>;<name>;<label>]
      		local newToolTip = "tooltip["..core.formspec_escape(icon_name)..";"
      		   ..core.formspec_escape(
      		      core.colorize("#00FF00", icon_title).."\n"
      		      .."* "..icon_descryption
      		   )
      		   ..";#004400;#FFFFFF"
      		.."]"
      		
      		local newAppButton = core.formspec_escape("image_"..icon_type).."["
      		   .."0.10,0"
      			..";1.35,1.35;"
      			..core.formspec_escape(icon_image)..";" --texture name
      			..core.formspec_escape(icon_name)..";" --button name
      			--..";" --label empty
      			--..core.formspec_escape(appname).." "..iconRow.."/"..iconCol.."\n"..core.formspec_escape("page:"..page.."\ninpg:"..iconInPage)..";"  --label
      			..";" --empty label
      			.."false;" --NOCLIP
      			.."false;" --drawborder
      			..core.formspec_escape(icon_image.."^[invert:rgb") --pressed texture name
      		.."]"
      		
      		local newAppLabel = "label[0.10,1.50;"
      		   ..core.formspec_escape(icon_title)
      		.."]"
      		
      		--modComputing.debug("newAppButton = "..dump(newAppButton) --[[, playername--]])
      		
      		formspec = formspec
      		.."container["
      			..(offSetX + (iconCol * marginConteinerX) + (iconCol * sizeButtonX))..","
      			..(offSetY + (iconRow * marginConteinerY) + (iconRow * sizeButtonY))
      		.."]"
      		--.."box[0,0;1.45,1.65;#00000088]"
      		..newToolTip..newAppButton..newAppLabel
      		.."container_end[]"
   		end --Final of: if page == modComputing.show_page[playername] then
   	end
	end --FONAL OF: for k,v in pairs(appnames) do
	
	local maxPages = math.floor((appsCount - 1) / (maxRow * maxCol)) --math.floor : arredonda sempre para menos
	if maxPages > 0 then
   	formspec = formspec
   	.."container[0,7.5]"
   	.."tooltip[btnPageBack;"
		   ..core.formspec_escape(modComputing.translate("BACK PAGE"))
		   ..";#004400;#FFFFFF"
		.."]"
      .."image_button[1.0,0;0.5,0.5;"
         ..core.formspec_escape("btn_page_change.png") --texture name
      	..";"..core.formspec_escape("btnPageBack") --button name
      	..";" --Empty Label
      	..";false" --NOCLIP
   		..";false" --drawborder
   		..";"..core.formspec_escape(
   		   "btn_page_change.png"
   		   .."^[invert:rgb"
   		) --pressed texture name
      .."]"
      
      .."label[1.75,0.25;"
         ..core.formspec_escape(
            modComputing.translate("Page")..":"
            ..("%02d"):format(modComputing.show_page[playername] + 1)
            .."/"
            ..("%02d"):format(maxPages + 1)
         )
      .."]"
      
      .."tooltip[btnPageNext;"
		   ..core.formspec_escape(modComputing.translate("NEXT PAGE"))
		   ..";#004400;#FFFFFF"
		.."]"
      .."image_button[4.0,0;0.5,0.5;"
         ..core.formspec_escape(
            "btn_page_change.png"
            .."^[transformFX"
         ) --texture name
      	..";"..core.formspec_escape("btnPageNext") --button name
      	..";" --Empty Label
      	..";false" --NOCLIP
   		..";false" --drawborder
   		..";"..core.formspec_escape(
   		   "btn_page_change.png"
            .."^[transformFX"
   		   .."^[invert:rgb"
         ) --texture name
      .."]"
      .."container_end[]"
   end
	
	return formspec
end

modComputing.show_smartphone = function(player)
	local playername = player:get_player_name()
	core.show_formspec(playername, "frmSmartphone", modComputing.smartphone.getFormSpec(player))
end

core.register_on_player_receive_fields(function(player, formname, fields)
   if type(formname)=="string" and formname=="frmSmartphone" then
      local playername = player:get_player_name()
      local appnames = modComputing.get_appnames()
   	local appsCount = table.getn(appnames)
   	local maxCol = modComputing.smartphone.maxCol
		local maxRow = modComputing.smartphone.maxRow
   	local maxPages = math.floor((appsCount - 1) / (maxRow * maxCol)) --math.floor : arredonda sempre para menos
   	--modComputing.debug("apps = "..dump(apps) --[[, playername--]])
   	
      if type(fields.btnPageBack)~="nil" then
         if modComputing.show_page[playername] > 0 then
            modComputing.show_page[playername] = modComputing.show_page[playername] - 1
            modComputing.show_smartphone(player)
         end
         return true --If function returns true, remaining functions are not called
      elseif type(fields.btnPageNext)~="nil" then
         if modComputing.show_page[playername] < maxPages then
            modComputing.show_page[playername] = modComputing.show_page[playername] + 1
            modComputing.show_smartphone(player)
         end
         return true --If function returns true, remaining functions are not called
      end
      
      
   	for k,v in pairs(appnames) do
   	   local apps = modComputing.get_apps()
   		local icon_name = apps[v].icon_name
   		local on_iconclick = apps[v].on_iconclick
   		if type(fields)=="table" and type(fields[icon_name])=="string" then
	         on_iconclick(player)
	         return true --If function returns true, remaining functions are not called
	      end
   	end
   end
end)


core.register_craftitem("computing:smartphone", {
	description = core.colorize(
	   "#00FF00", modComputing.translate("SMARTPHONE")
	).."\n"
	.."* "..modComputing.translate(
	   "A mobile device that contains @n"
	   .."several apps generated by @n"
	   .."integrating other mods."
	),
	inventory_image = "icon_smartphone_128x128.png",
	--use_texture_alpha = "clip", --para nods
	groups = {
	   electric=1,
	   electronic=1,
	   device=1,
	   portable=1,
	   smartphone=1,
	},
	on_use = function(itemstack, player, pointed_thing)
   	modComputing.show_smartphone(player)
	end,
})

modComputing.is_allow_smartphone_recipe = function(player)
   if type(modComputing.strSmartphoneRecipe)~="boolean" then
      modComputing.strSmartphoneRecipe = core.settings:get(modComputing.modname..".smartphone_recipe")
      modComputing.strSmartphoneRecipe = type(modComputing.strSmartphoneRecipe)~="string" or (type(modComputing.strSmartphoneRecipe)=="string" and modComputing.strSmartphoneRecipe:lower() ~= "false")
      --core.settings:set_bool(modComputing.modname..".smartphone_recipe", modComputing.strSmartphoneRecipe)
      --core.settings:write()
   end
   return modComputing.strSmartphoneRecipe
end

--[[ ]]
if modComputing.is_allow_smartphone_recipe() then
   if not minetest.get_modpath("components") then
      core.register_craft({
      	output = 'computing:smartphone',
      	recipe = {
      		{"default:obsidian_glass"	,"default:obsidian_glass"	,"default:book"},
      		{"default:obsidian_glass"	,"default:obsidian_glass"	,"default:mese_crystal"},
      		{"default:obsidian_glass"	,"default:obsidian_glass"	,"keys:skeleton_key"},
      	}
      })
   else
      core.register_craft({
      	output = 'computing:smartphone',
      	recipe = {
      		{"default:obsidian_glass"	,"default:obsidian_glass"     ,"components:speaker"},
      		{"default:obsidian_glass"	,"components:touch_screen"    ,"components:computer"},
      		{"default:obsidian_glass"	,"default:obsidian_glass"     ,"components:power_cell"},
      	}
      })
   end
end
--[[ ]]

core.register_alias("smartphone", "computing:smartphone")
core.register_alias(modComputing.translate("smartphone"), "computing:smartphone")



