A message from _Exile_ founder Dokimi, first published 2020-08-02.
Edited and updated by the community.

# Design Guide

This document is intended for anyone who wants to develop _Exile_ further (or to make mods for _Exile_, or who just wants to know what I could possibly have been thinking).

_Exile_ is an open-source project. I would never have gotten it this far without other people’s open-source content.
_Exile_’s long-term existence (after I get bored/abducted by aliens/die of the plague/eaten by spiders/etc.) will depend on people in the open-source community picking up were I’ve left off.

This document sets out to help you improve the game without ruining it! (And thereby annoying me.)
So here is _Exile_’s design philosophy…

 The Aim of _Exile_
===============================
Exile is a game: mere escapism, a bit of fun — nothing too serious.

At the same time, people often seek escapism at precisely those moments when life is hardest.
Therefore the goal of _Exile_ is to be the kind of escapism that leaves you feeling better.
Exile aims to be the kind of escapism that helps during those moments when you are seeking “Exile” from the world.

That is the ultimate, lofty, aspiration of _Exile_. Hu-rah!

In the likely event _Exile_ fails to help you achieve enlightenment / self-actualization / transmogrification / a rocking bod / etc., _Exile_ should at least be fun.

I’ll be happy with fun.

Inspirations
===============================
Dokimi’s cites several areas of inspiration for the themes found ing _Exile_:
- _Rimworld_ space-colony simulator by Tynan Sylvester
- _The Primitive Technology Guy_ on YouTube (John Plant)
- various historical re-enactments of old technology,
- various survivalist / wilderness / off-the-grid living things, …

Basically, _Exile_ is a first-person version of _Rimworld_, but with a bit more attention to representing things realistically and accurately. That’s a massive simplification, but close enough.

Design Rules 
===============================
_(Sometimes more like guidelines…or aspirations!)_
- Choice-focused realism:
  - The game world should make you behave how you would in the real world.
  - This is not to be confused with pedantic realism. Pedantic realism gives you 150 types of coal which take 15 hours real time to dig — because that’s “realistic.”
  - In contrast to pedantic realism, choice-focused realism would emphasize the fact that coal is non-renewable, so compared with using wood you need to make different decisions.

- Player Welfare:
  - Games are escapism. People need escapism, but some of the escapism on offer is damaging to people.
  - Exile should be escapism that leaves you feeling better (or at least not worse off).
    - E.g. the skills needed to succeed should be valuable in real life (planning, creativity, identifying materials).
    - E.g. the breaktaker screen exists to stop players from spending an unhealthy amount of time sitting.

- Function first:
  - I’ve been reluctant to add anything that is purely decorative. Almost everything has some use. The use is why it got added to the game. I break this rule if aesthetics (or fun) requires it.

- Clarity:
  - The player should be trying to figure out the world of Exile, not the user interface of Exile!
  - Menus, information, etc. should be tidy, uncluttered and easy to understand.
    - E.g. crafting stations ideally have one page of crafts (for easy access).
    - E.g. non-obvious “gamey” mechanics (things that exist due to the limits of making a game) ought to be documented somewhere.

- Secrets:
  - This is a game to reward experimentation, creativity, and exploration.  
  - Mastering survival and technology is never about “leveling up” — it’s about figuring out how the natural world works.

- The Edge of Impossible
  - Difficulty should be at the edge of success and failure: Not so easy that it gets boring, yet not so hard that you give up. 
  - You should be forced to make difficult decisions without knowing in advance if they will work. I find this makes for the most interesting and satisfying gameplay.
  - You can feel the pride of having used skill to achieve something genuinely difficult — even if it is just a game!
  - This concept is not to be confused with a self-abasing desire to experience suffering for its own sake, nor a foolhardy celebration of “strength” over “weakness.” Achieving “Edge of Impossible” is about personal growth via overcoming adversity.

- Meaning
  - Exile exists in its own world. Names, characters, objects, etc., are chosen to build a consistent world which feels like a real place with a real history.
  - The player should have ways of adding meaning to the world.
    - E.g. plants and animals have unique names (not just copies of real species).
    - E.g. soft perma-death. Each player life is treated as a new character.
    - E.g. paint tools allow creation of art, symbolic markings.

- Dynamism
  - The world is alive. It is doing it’s own thing. It will act and you must respond (and vice versa).
  - Stories and challenges should emerge out of the world itself, whether you are ready or not.

- Artistic Value
  - Can a game be art? Might as well try…
  - (At the very least it should look good!)

Aesthetics
===============================
I don’t know how to describe my “Art Style”. Look at it. It is that.

A rule for good art is pick one dominant color, one secondary color, and one rare color.

Each biome more-or-less follows this rule, such as how grasslands are yellow, dunelands are orange, etc. The Ancients (artifacts) tend to go for blue.

Naming
===============================
Many of the names for plants and animals were adapted from foreign languages so they feel natural.
Some biomes tended to focus on different language regions — for example, African names for grasslands, Celtic for marshlands, Southeast Asian for forests, Indian for underground, …

“Realms”
===============================
- ___Surface world___ — Mostly complete. the ordinary wilderness. Harsh to the unwise, abundant to the experienced.

- ___Ancient city___ — Partly incomplete. A mysterious, awe inspiring and dangerous place.
Should feel like “the Zone” from “Roadside Picnic” by the Strugatsky brothers,
or like Chernobyl if explored by a cave man. A place of high risks and high rewards,
of follies and greed, of madness, of darkness, and of grandeur.

Something could also be done with…

- ___Deep underground___ — Extremely hot. The map gets deep enough to reach the edge of the Earth’s mantle.

- ___High altitude___ — Very cold. High enough to reach the edge of the atmosphere, but not space proper.

Lore and Story
===============================
## The Story:
You have been thrown into exile for your crimes. You have been sent to a cursed land.
A place were every nation sends the condemned, the unwanted, and the politically inconvenient. It is seen as execution by other means.

You task is to cheat fate and live.

The reason this land is cursed is the stuff of many legends and myths. It is believed to have been the location of the world’s first and greatest city, yet no trace of it remains. Legend has it that the inhabitants in their arrogance and pride brought about their own destruction. A great cataclysm that rendered the land the hostile place it now is.

The Ancients were scattered to the four corners of the world — exiled from their city.
Many nations claim descent from these people, though of course it is probably all just stories.

The technology of the Ancients is said to have been far beyond anything now existing.
Some say it was magic. Some say skill. Some say there is no difference. The world of today is at an early Iron Age level — that is the only technology with which you have any familiarity.

Your second task, if you choose, is to figure out if the myths are true.

## Future:
Various more-detailed plotlines and content could be spun off from these two game goals.
But it’s still the early days, so not much is here yet!

Some big story could be done involving discovering how and why the city was destroyed then running through the implications of this discovery. Perhaps….
