
local c_alpha = minimal.compat_alpha

local function destruct_bed(pos, n)
	local node = minetest.get_node(pos)
	local other

	if n == 2 then
		local dir = minetest.facedir_to_dir(node.param2)
		other = vector.subtract(pos, dir)
	elseif n == 1 then
		local dir = minetest.facedir_to_dir(node.param2)
		other = vector.add(pos, dir)
	end

	local oname = minetest.get_node(other).name
	if minetest.get_item_group(oname, "bed") ~= 0  then
		-- Swap node leaves meta, but doesn't call destruct_bed again
		minetest.swap_node(other, {name = "air"})
		minetest.remove_node(other) -- Now clear meta
		minetest.check_for_falling(other)
	end
end


local function is_invalid_pos(pos, player_name)
   if minetest.is_protected(pos, player_name) and
      not minetest.check_player_privs(player_name, "protection_bypass") then
      minetest.record_protection_violation(pos, player_name)
      return true
   end

   local node_def = minetest.registered_nodes[minetest.get_node(pos).name]
   if not node_def or not node_def.buildable_to
      or string.match(node_def.drawtype, "liquid")
      or node_def.drawtype == "plantlike"
      or node_def.drawtype == "signlike"
      or node_def.drawtype == "torchlike"
      or node_def.drawtype == "firelike"
   then
      return true
   end
   return false
end


----------------------------------------
function bed_rest.register_bed(name, def)
	minetest.register_node(name .. "_bottom", {
		description = def.description,
		inventory_image = def.inventory_image,
		wield_image = def.wield_image,
		drawtype = "nodebox",
		tiles = def.tiles.bottom,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = c_alpha.clip,
		is_ground_content = false,
		stack_max = def.stack_max,
		groups = def.groups,
		sounds = def.sounds,
		node_box = {
			type = "fixed",
			fixed = def.nodebox.bottom,
		},
		selection_box = {
			type = "fixed",
			fixed = def.selectionbox,
		},

		walkable = def.walkable,
		buildable_to = def.buildable_to or false,
		floodable = def.floodable or false,
		on_punch = def.on_punch,


		on_place = function(itemstack, placer, pointed_thing)
			local under = pointed_thing.under
			local node = minetest.get_node(under)
			local udef = minetest.registered_nodes[node.name]
			if udef and udef.on_rightclick and
					not (placer and placer:is_player() and
					placer:get_player_control().sneak) then
				return udef.on_rightclick(under, node, placer, itemstack,
					pointed_thing) or itemstack
			end

			local pos
			if udef and udef.buildable_to then
				pos = under
			else
				pos = pointed_thing.above
			end

			local playername = ""
			if placer and placer:is_player() then
			   playername = placer:get_player_name()
			end

			if is_invalid_pos(pos, playername) then
				return itemstack
			end

			local dir = placer and placer:get_look_dir() and
				minetest.dir_to_facedir(placer:get_look_dir()) or 0
			local botpos = vector.add(pos, minetest.facedir_to_dir(dir))
			if is_invalid_pos(botpos, playername) then
				return itemstack
			end

			minetest.set_node(pos, {name = name .. "_bottom", param2 = dir})
			minetest.set_node(botpos, {name = name .. "_top", param2 = dir})

			if not (creative and creative.is_enabled_for
					and creative.is_enabled_for(playername)) then
				itemstack:take_item()
			end
			return itemstack
		end,

		preserve_metadata = function(pos, oldnode, oldmeta, drops)
			local bedInv = minetest.get_meta(pos):get_inventory()
			local blanket=bedInv:get_stack('main',1)
			if blanket:get_count() > 0 then
				drops[2]=blanket
			end
		end,

		on_destruct = function(pos)
			destruct_bed(pos, 1)
		end,

		on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
			bed_rest.on_rightclick(pos, clicker, def.bed_level)
			local stack = clicker:get_wielded_item()
			--Update wielded item, in case it's a moved blanket
			return stack
		end,

		on_rotate = function(pos, node, user, _, new_param2)
			local dir = minetest.facedir_to_dir(node.param2)
			local p = vector.add(pos, dir)
			local node2 = minetest.get_node_or_nil(p)
			if not node2 or not minetest.get_item_group(node2.name, "bed") == 2 or
					not node.param2 == node2.param2 then
				return false
			end
			if minetest.is_protected(p, user:get_player_name()) then
				minetest.record_protection_violation(p, user:get_player_name())
				return false
			end
			if new_param2 % 32 > 3 then
				return false
			end
			local newp = vector.add(pos, minetest.facedir_to_dir(new_param2))
			local node3 = minetest.get_node_or_nil(newp)
			local node_def = node3 and minetest.registered_nodes[node3.name]
			if not node_def or not node_def.buildable_to then
				return false
			end
			if minetest.is_protected(newp, user:get_player_name()) then
				minetest.record_protection_violation(newp, user:get_player_name())
				return false
			end
			node.param2 = new_param2
			-- do not remove_node here - it will trigger destroy_bed()
			minetest.swap_node(p, {name = "air"})
      minetest.remove_node(p)
			minetest.swap_node(pos, node)
			minetest.swap_node(newp, {name = name .. "_top", param2 = new_param2})
			return true
		end,
		can_dig = function(pos, player)
			return bed_rest.can_dig(pos, player)
		end,
		on_timer = function(pos, elapsed)
		   return bed_rest.on_timer(pos, elapsed)
		end,
	})

	minetest.register_node(name .. "_top", {
		drawtype = "nodebox",
		tiles = def.tiles.top,
		paramtype = "light",
		paramtype2 = "facedir",
		use_texture_alpha = c_alpha.clip,
		is_ground_content = false,
		pointable = false,
		groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 3, bed = 2, temp_pass = 1},
		sounds = def.sounds,
		drop = name .. "_bottom",
		node_box = {
			type = "fixed",
			fixed = def.nodebox.top,
		},
		on_destruct = function(pos)
			destruct_bed(pos, 2)
		end,
		can_dig = function(pos, player)
			local node = minetest.get_node(pos)
			local dir = minetest.facedir_to_dir(node.param2)
			local p = vector.add(pos, dir)
			return bed_rest.can_dig(p, player)
		end,

		walkable = def.walkable,
		buildable_to = def.buildable_to or false,
		floodable = def.floodable or false,
		on_punch = def.on_punch,

	})

	minetest.register_alias(name, name .. "_bottom")
end
