# Exile
Version 0.3.0

by Dokimi

For Minetest 5.4

### Installation
Exile should be in games folder like so:

Minetest > games > exile > mods/menu/... etc

Since 0.2.3, Exile requires naturalslopeslib. If you're installing the source
from git, you'll need to install nsl as well. Extract it into the exile mods/
folder.

### Gameplay
Challenging, at times brutal, wilderness survival with simple technology.
Use your wits to find food, water, and shelter before succumbing to the elements,
while exploring the mysterious world, and developing your capacities to endure your exile.

Features:
Player health effects: hypothermia, exhaustion, disease...
Dynamic nature: Seasonal weather, erosion, soil water flows...
Building matters: make shelters from the rain, kilns, smelters,...

CAUTION: some people may find parts of this game difficult or disturbing.

### Gameplay Guide
Check out doc > walkthrough for a more detailed guide.

Many different strategies might work, and part of the fun is figuring out what does,
and catastrophically does not, work.

Here are some early steps you might pass though:
1. Make basic tools. Find a suitable camp site.
2. Build a bed to rest in, shelter, and maybe fire for warmth.
3. Make a kiln, and make pots. Harvest wild foods while you wait.
4. Collect water with pots, and build up a water supply.
5. Farm food, drugs, and fibre to build up supplies.
6. Explore and gather resources for more advanced tools.

You start in spring. Soon the hot dry weather of summer will arrive.
Running out of water, or getting exhausted by the heat is a real risk.
After that will come the sub-zero conditions of winter.
Starvation and freezing are hard to avoid without preparation.


Some tips and tricks:
- Beds are important. If you're exhausted you get hypothermia/heat stroke. Get under shelter in a nice temperature.
- Do your crafting, organizing, planning while you rest.
- Weather: extremes sap your energy. Like real life, walking around in a snowstorm is a bad idea!
- Temperature. Build a shelter, with a fire place or lots of torches. You can also go underground.
- Go deep enough underground and you might find something....
- Water: you can drink cave drips (click them). Water pots collect rain water. Some plants, food has water.
- Keep an eye on "health effects". You may have eaten something bad, or have a terrible disease.
- Ovens, kilns, furnaces: build them like you would for real. A fire with access to air, and a chamber that gets heated up.
- Fires. Blocks are hotter. Charcoal is hotter than wood. Fires can be temporarily extinguished by punching them holding sediment.
- iron smelting. This is hard. Needs charcoal.
- Charcoal. Make it like you would for real. A wood fire with no air.
- Food: eat stuff and see if you live! You can catch animals with clubs (right click)
- Farming: digging tools also can till soil. Punching depleted farm soil with fertilizers will restore it.
- Drugs: some plants have useful effects. Be careful not to OD on drugs.
- Not every step in crafting can be done at a work station. Some things need to be fired, or soaked in water etc.
- Build stairs and shelters around your base, this will save you energy and protect you from extremes.

### Development
Exile is opensource - that means it is as good as you choose to make it.
It also means development can be erratic and haphazard at times, so be patient!

Exile is currently in Alpha, therefore expect bugs, missing features, performance issues,
and compatibility breaking updates.
Despite this, Exile does have enough features to be a playable game without too many crashes.

See Doc > Issues_ToDo for a list of known bugs, missing features etc
See Doc > Development_Process for more details

### Credit
Thanks is due to all those whose mods have been adapted for use in Exile (see mod folders for details).

Thanks also to all who have given feedback, fixes etc.

### Changelog:

# 0.1
- Initial release

# 0.2
- clothing (plus multiskin model, new player api), weaving frame, temperature tolerance via clothing
- Lore: exile letter
- Sleeping spot
- new mobs: darkasthaan, impethu, pegasun, sneachan
- cookable animal carcasses
- graffitti: glow paint
- new building materials: rammed earth, bricks and mortar, roof tiles, wooden doors/floors/stair, mortared masonry
- fixed dungeon loot
- added more artifacts (airboat, art, transporter, wayfinder...)
- mushrooms for fibre, food/water, sticks (artifact species)
- split geomoria into realms (highways, and city structure)
- added more geomorphs
- gneiss and jade for deep underground biome
- better looking bones
- newly formatted colored skies
- climate chat commands
- Design Guide
- updated backgrounds
- updated version of crafting
- various minor fixes
- various minor balance changes
- various minor additions
- Minetest 5.3 compatibility

# 0.2.1
- fix exile letter crash
- fix salt water surface sediment crash
- fix for multiplayer health tab crash
- balance and bugfix animals
- adjust ice freezing and thawing

# 0.2.2
- new HUD
- character page
- health effects
- Drugs: Tiku, Tang, metastim
- megamorph surface airshafts
- fix clothing infinite tolerance bug
- iron fittings for crafts
- old and young Tangkal trees
- Tiken woody cane
- cave sediments and mushrooms
- puts_out_fire group (e.g. mud now puts out fire), masonry group
- walkthrough doc
- loose wattle
- mashed anperla
- misc minor fixes and balancing

# 0.2.3
- new dependency: naturalslopeslib
- ability to throw torches for light
- settings for breaktaker
- ability to display temperature in Celsius, Fahrenheit, or Kelvin
- food burns instead of vanishing, thanks to ts
- farming improvements
- fixes for fire and rain
- many fixes for crashes and bugs

# 0.3.0
- Initial release for Minetest 5.4.0, use v0.2 line for 5.3.0
