local hyper = ... -- Loads non-global namespace table: hyper

local edit_mode = false -- Whether to show the meta list or editing window
local scans = {} -- hold on to playername & target meta for edit operations
--[[
    name = {
        meta = nil -- last scanned item or node's meta object
        name = { [0] = "foo", [1] = "bar", ... }, -- field # to name
        selrow = 1 -- current selected meta entry, default 1
        key = currently selected row's key name
        undo = nil -- saves info to undo the last meta change
    }
]]--

local function parse_meta(meta, pname)
    local mtable = meta:to_table()
    local fields = mtable and mtable.fields
    if not fields then
        return "hypertext[0.5,1;8,7;panel_meta;No meta found]"
    end
    local it = scans[pname]
    local fmt = {} -- reformatted for concise display, not for editing!
    local alphabetized = {}
    for name,value in pairs(fields) do
        local nvalue = core.strip_colors(value)
        nvalue = nvalue:trim()
        nvalue = nvalue:gsub("\n","") -- Trim doesn't get rid of newlines??
        nvalue = core.formspec_escape(nvalue)
        fmt[name] = nvalue
        if name ~= "formspec" then -- skip that, please
            table.insert(alphabetized, name)
        end
    end
    table.sort(alphabetized)
    it.name = alphabetized
    if not it.selrow then
        it.selrow = 1 it.key = alphabetized[1]
    end
    local out = {
        "tableoptions[border=true]",
        "tablecolumns[text,width=12;text,align=right]",
        "table[0.5,0.5;8,6;metalist;"
    }
    for i = 1, #alphabetized do
        local name = alphabetized[i]
        local tag = ""
        if it.undo and it.undo[name] then
            tag = "* " -- This entry has undo information
        end
        table.insert(out, table.concat({ tag, name, ",", fmt[name], "," }))
    end
    out[#out+1] = ";"..it.selrow.."]"

        table.insert(
            out, table.concat({
                "field[2.25,7;4.5,0.5;ht_metakey;;", it.key or "","]",
                "field_close_on_enter[ht_metakey;false]",
                "button[7,7;1.5,0.5;ht_metaedit;Edit]"
        }))
    if it.undo and it.undo[it.key] then -- Display undo button
        out[#out+1] = "button[0.5,7;1.5,0.5;ht_metaundo;Undo]"
    end

    --out[#out+1] = "label[3,7;Double click to edit"
    --out[#out+1] = "button[1,7;1.5,0.5;ht_openmetaedit;Edit]"
    return table.concat(out)
end


local function edit_window(meta, player, fname)
    local curvalue = meta:get_string(fname)
    local out = { "label[1,0.5;Edit meta:]",
        "style[ht_metaeditor;font=mono]",
        "textarea[1,1;7,5;ht_metaeditor;"..fname..";"..curvalue.."]",
        "button[2,7;2,0.5;ht_metacancel;Cancel]",
        "button[6,7;2,0.5;ht_metasave;Save]" }
    return table.concat(out)
end

local function ht_meta_recfield(player, formname, fields, pname)
    local it = scans[pname] ; if not it then return end
    if fields.metalist then
        local ev = core.explode_table_event(fields.metalist)
        local fname = it.name[ev.row]
        if ev.type == "CHG" then
            it.selrow = ev.row
            it.key = it.name[it.selrow]
        end
        if ev.type == "DCL" and fname then
            edit_mode = fname
        end
        return true -- update tab display
    end
    if fields.ht_metaedit and fields.ht_metakey ~= "" then
        it.key = fields.ht_metakey
        edit_mode = it.key
        return true
    end
    if fields.ht_metacancel then
        edit_mode = false
        return true
    end
    if fields.ht_metasave then
        it.undo = it.undo or {}
        it.undo[it.key] = it.meta:get_string(it.key)
        it.meta:set_string(it.key, fields.ht_metaeditor)
        edit_mode = false
        return true
    end
    if fields.ht_metaundo then
        it.meta:set_string(it.key, it.undo[it.key])
        it.undo[it.key] = nil
        return true
    end
end

table.insert(hyper.tab_recfield, ht_meta_recfield)


function hyper.panel_meta(meta, player)
    local name = player:get_player_name()
    if edit_mode ~= false then
        return edit_window(meta, player, edit_mode)
    end
    if not scans[name] or scans[name].meta ~= meta then -- new or changed
        scans[name] = { meta = meta }
    end
    return parse_meta(meta, name)
end
