local unpointed = {} -- tracking who's doing what

local function get_pointed_pos(player, range)
    if not minetest.is_player(player) then return end -- disconnected
        local ppos = player:get_pos()
    local offset = player:get_eye_offset()
    local eye_height = player:get_properties().eye_height + ( offset.y / 10 )
    ppos.y = ppos.y + eye_height
    local lookdir = vector.multiply(player:get_look_dir(), range)
    local pointpos = vector.add(ppos, lookdir)
    return pointpos
end

local hud_type =  "hud_elem_type" -- compatibility with MT 5.8.0 and below
if minetest.has_feature("hud_def_type_field") == true then
   hud_type = "type"
end

local hud2x = 300

local function init_unpoint_hud(player, pname)
    unpointed[pname] = {}
    unpointed[pname].hud = player:hud_add({
                [hud_type] = "text",
                position = {x = 0.8, y = 0.2},
                offset = { x = 0, y = 0 },
                alignment = {x = 0, y = 0},
                number = 0xFFFFFF,
                text = "",
    })
    unpointed[pname].hud2 = player:hud_add({
                [hud_type] = "image",
                position = {x = 0.8, y = 0.2},
                offset = { x = 0, y = 0 },
                alignment = {x = 0, y = 0},
                scale = { x = hud2x, y = 50 },
                z_index = -100,
                text = "RMU_background.tga",
    })

end

local function update_point(player, pname, stack)
    if not unpointed[pname] then init_unpoint_hud(player, pname) end
    local nodepos = get_pointed_pos(player, 3)
    local node = minetest.get_node(nodepos)
    local timer =
        unpointed[pname].pos and nodepos:equals( unpointed[pname].pos )
        and unpointed[pname].timer

        or minetest.get_node_timer(nodepos)
    unpointed[pname].pos = nodepos
    unpointed[pname].timer = timer
    unpointed[pname].name = node.name
    local tstring = "" ; local hud2y = 50
    if timer:is_started() then
        tstring = table.concat({
                "\n Timer: ",
                tostring(math.floor(timer:get_elapsed()))," / ",
                tostring(timer:get_timeout()) })
        hud2y = 80
    end
    player:hud_change(unpointed[pname].hud, 'text',
                      table.concat({node.name,
                                    "\n p1: ", tostring(node.param1),
                                    "  p2: ", tostring(node.param2),
                                    tstring
                      })
    )
    player:hud_change(unpointed[pname].hud2, 'scale', { x = hud2x, y = hud2y })
end

local function remove_point(player, pname)
    player:hud_remove(unpointed[pname].hud)
    player:hud_remove(unpointed[pname].hud2)
    unpointed[pname] = nil
end

return update_point, remove_point, unpointed
